/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.DynamicSetting;

public class ExtSettings
extends DynamicSetting<ExtSettings> {
    private Map<String, String> extSettings;

    ExtSettings(@Nonnull Map<String, String> extSettings) {
        this.extSettings = Objects.requireNonNull(extSettings, "extSettings must not be null");
    }

    @Override
    @Nonnull
    protected String getName() {
        return "extSettings";
    }

    @Override
    @Nonnull
    protected BiFunction<ExtSettings, ExtSettings, String> getDiffEvaluator() {
        return (oldValue, newValue) -> {
            LinkedHashSet<String> sameEntries = new LinkedHashSet<String>(newValue.extSettings.keySet());
            sameEntries.retainAll(oldValue.extSettings.keySet());
            LinkedHashSet<String> entriesInNew = new LinkedHashSet<String>(newValue.extSettings.keySet());
            entriesInNew.removeAll(oldValue.extSettings.keySet());
            LinkedHashSet<String> entriesInOld = new LinkedHashSet<String>(oldValue.extSettings.keySet());
            entriesInOld.removeAll(newValue.extSettings.keySet());
            StringJoiner diff = new StringJoiner(",", this.getName() + '(', ")");
            sameEntries.forEach(key -> diff.add(key + '=' + newValue.extSettings.get(key) + '<' + oldValue.extSettings.get(key)));
            entriesInNew.forEach(key -> diff.add(key + '=' + newValue.extSettings.get(key) + '<' + null));
            entriesInOld.forEach(key -> diff.add(key + '=' + null + '<' + oldValue.extSettings.get(key)));
            return diff.toString();
        };
    }

    @Override
    @Nonnull
    protected ExtSettings getThis() {
        return this;
    }

    @Override
    protected void copyFields(@Nonnull ExtSettings newValue) {
        this.extSettings = newValue.extSettings;
    }

    @Nonnull
    public Duration getDurationProperty(@Nonnull String settingName) {
        return Duration.parse(this.getProperty(settingName));
    }

    @Nonnull
    public String getProperty(@Nonnull String settingName) {
        Objects.requireNonNull(settingName);
        return Objects.requireNonNull(this.extSettings.get(settingName), String.format("null values are not allowed: settingName=%s", settingName));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExtSettings that = (ExtSettings)obj;
        return Objects.equals(this.extSettings, that.extSettings);
    }

    public int hashCode() {
        return Objects.hash(this.extSettings);
    }

    public String toString() {
        return this.extSettings.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, String> extSettings;

        private Builder() {
        }

        public Builder withSettings(@Nonnull Map<String, String> extSettings) {
            this.extSettings = extSettings;
            return this;
        }

        public ExtSettings build() {
            return new ExtSettings(this.extSettings);
        }
    }
}

