/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.time.Duration;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.DynamicSetting;
import ru.yoomoney.tech.dbqueue.settings.FailRetryType;

public class FailureSettings
extends DynamicSetting<FailureSettings> {
    @Nonnull
    private FailRetryType retryType;
    @Nonnull
    private Duration retryInterval;

    private FailureSettings(@Nonnull FailRetryType retryType, @Nonnull Duration retryInterval) {
        this.retryType = Objects.requireNonNull(retryType, "retryType must not be null");
        this.retryInterval = Objects.requireNonNull(retryInterval, "retryInterval must not be null");
    }

    @Nonnull
    public FailRetryType getRetryType() {
        return this.retryType;
    }

    @Nonnull
    public Duration getRetryInterval() {
        return this.retryInterval;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FailureSettings that = (FailureSettings)obj;
        return this.retryType == that.retryType && this.retryInterval.equals(that.retryInterval);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.retryType, this.retryInterval});
    }

    public String toString() {
        return "{retryType=" + (Object)((Object)this.retryType) + ", retryInterval=" + this.retryInterval + '}';
    }

    @Override
    @Nonnull
    protected String getName() {
        return "failureSettings";
    }

    @Override
    @Nonnull
    protected BiFunction<FailureSettings, FailureSettings, String> getDiffEvaluator() {
        return (oldVal, newVal) -> {
            StringJoiner diff = new StringJoiner(",", this.getName() + '(', ")");
            if (!Objects.equals((Object)oldVal.retryType, (Object)newVal.retryType)) {
                diff.add("retryType=" + (Object)((Object)newVal.retryType) + '<' + (Object)((Object)oldVal.retryType));
            }
            if (!Objects.equals(oldVal.retryInterval, newVal.retryInterval)) {
                diff.add("retryInterval=" + newVal.retryInterval + '<' + oldVal.retryInterval);
            }
            return diff.toString();
        };
    }

    @Override
    @Nonnull
    protected FailureSettings getThis() {
        return this;
    }

    @Override
    protected void copyFields(@Nonnull FailureSettings newValue) {
        this.retryType = newValue.retryType;
        this.retryInterval = newValue.retryInterval;
    }

    public static class Builder {
        private FailRetryType retryType;
        private Duration retryInterval;

        public Builder withRetryType(@Nonnull FailRetryType retryType) {
            this.retryType = retryType;
            return this;
        }

        public Builder withRetryInterval(@Nonnull Duration retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public FailureSettings build() {
            return new FailureSettings(this.retryType, this.retryInterval);
        }
    }
}

