/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.FailRetryType;
import ru.yoomoney.tech.dbqueue.settings.FailureSettings;

class FailureSettingsParser {
    private final Supplier<FailureSettings.Builder> defaultSettings;
    private final List<String> errorMessages;

    FailureSettingsParser(@Nonnull Supplier<FailureSettings.Builder> defaultSettings, @Nonnull List<String> errorMessages) {
        this.defaultSettings = Objects.requireNonNull(defaultSettings, "defaultSettings");
        this.errorMessages = Objects.requireNonNull(errorMessages, "errorMessages");
    }

    Optional<FailureSettings> parseSettings(@Nonnull String queueId, @Nonnull Map<String, String> settings) {
        Objects.requireNonNull(queueId, "queueId");
        Objects.requireNonNull(settings, "settings");
        try {
            FailureSettings.Builder failureSettings = this.defaultSettings.get();
            settings.forEach((key, value) -> this.fillSettings(failureSettings, (String)key, (String)value));
            return Optional.of(failureSettings.build());
        }
        catch (RuntimeException exc) {
            this.errorMessages.add(String.format("cannot build failure settings: queueId=%s, msg=%s", queueId, exc.getMessage()));
            return Optional.empty();
        }
    }

    private void fillSettings(FailureSettings.Builder failureSettings, String name, String value) {
        try {
            switch (name) {
                case "retry-type": {
                    failureSettings.withRetryType(FailureSettingsParser.parseRetryType(value));
                    return;
                }
                case "retry-interval": {
                    failureSettings.withRetryInterval(Duration.parse(value));
                    return;
                }
            }
            return;
        }
        catch (RuntimeException exc) {
            this.errorMessages.add(String.format("cannot parse setting: name=%s, value=%s, exception=%s", name, value, exc.getClass().getSimpleName() + '(' + exc.getMessage() + ')'));
            return;
        }
    }

    private static FailRetryType parseRetryType(String name) {
        switch (name) {
            case "geometric": {
                return FailRetryType.GEOMETRIC_BACKOFF;
            }
            case "arithmetic": {
                return FailRetryType.ARITHMETIC_BACKOFF;
            }
            case "linear": {
                return FailRetryType.LINEAR_BACKOFF;
            }
        }
        throw new IllegalArgumentException(String.format("unknown retry type: name=%s", name));
    }
}

