/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class FileWatcher {
    private static final Logger log = LoggerFactory.getLogger(FileWatcher.class);
    @Nonnull
    private final ExecutorService executor;
    @Nonnull
    private final Path watchedFile;
    @Nonnull
    private final Path watchedDir;
    @Nonnull
    private final Runnable onChangeCallback;
    private WatchService watchServiceFileDir;

    FileWatcher(@Nonnull Path watchedFile, @Nonnull Runnable onChangeCallback) {
        this.onChangeCallback = Objects.requireNonNull(onChangeCallback, "onChangeCallback must not be null");
        this.executor = Executors.newSingleThreadExecutor();
        this.watchedFile = Objects.requireNonNull(watchedFile, "watchedFile must not be null");
        this.watchedDir = watchedFile.getParent();
        if (this.watchedDir == null) {
            throw new IllegalArgumentException("directory of watched file is empty");
        }
        if (!watchedFile.toFile().isFile()) {
            throw new IllegalArgumentException("watched file is not a file: file=" + watchedFile);
        }
    }

    synchronized void startWatch() {
        log.info("Starting watch for file changes: file={}", (Object)this.watchedFile);
        try {
            this.startWatchFileDirectory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    synchronized void stopWatch() {
        try {
            log.info("Stopping watch for file changes: file={}", (Object)this.watchedFile);
            if (this.watchServiceFileDir != null) {
                this.watchServiceFileDir.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void startWatchFileDirectory() throws IOException {
        if (this.watchServiceFileDir != null) {
            this.watchServiceFileDir.close();
        }
        this.watchServiceFileDir = this.watchedDir.getFileSystem().newWatchService();
        this.watchedDir.register(this.watchServiceFileDir, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.executor.execute(() -> FileWatcher.doWatch(this.watchServiceFileDir, this.watchedFile.toFile(), this.onChangeCallback));
    }

    private static void doWatch(WatchService watchService, File file, Runnable callback) {
        try {
            WatchKey watchKey;
            while ((watchKey = watchService.take()) != null) {
                List<WatchEvent<?>> polledEvents = watchKey.pollEvents();
                boolean fileModified = polledEvents.stream().filter(watchEvent -> !Objects.equals(watchEvent.kind(), StandardWatchEventKinds.OVERFLOW)).map(watchEvent -> watchEvent.context().toString()).anyMatch(fileName -> fileName.equals(file.getName()));
                if (fileModified) {
                    callback.run();
                }
                watchKey.reset();
            }
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            // empty catch block
        }
    }
}

