/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.time.Duration;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.DynamicSetting;

public class PollSettings
extends DynamicSetting<PollSettings> {
    @Nonnull
    private Duration betweenTaskTimeout;
    @Nonnull
    private Duration noTaskTimeout;
    @Nonnull
    private Duration fatalCrashTimeout;

    private PollSettings(@Nonnull Duration betweenTaskTimeout, @Nonnull Duration noTaskTimeout, @Nonnull Duration fatalCrashTimeout) {
        this.betweenTaskTimeout = Objects.requireNonNull(betweenTaskTimeout, "betweenTaskTimeout must not be null");
        this.noTaskTimeout = Objects.requireNonNull(noTaskTimeout, "noTaskTimeout must not be null");
        this.fatalCrashTimeout = Objects.requireNonNull(fatalCrashTimeout, "fatalCrashTimeout must not be null");
    }

    @Nonnull
    public Duration getBetweenTaskTimeout() {
        return this.betweenTaskTimeout;
    }

    @Nonnull
    public Duration getNoTaskTimeout() {
        return this.noTaskTimeout;
    }

    @Nonnull
    public Duration getFatalCrashTimeout() {
        return this.fatalCrashTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PollSettings that = (PollSettings)obj;
        return this.betweenTaskTimeout.equals(that.betweenTaskTimeout) && this.noTaskTimeout.equals(that.noTaskTimeout) && this.fatalCrashTimeout.equals(that.fatalCrashTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.betweenTaskTimeout, this.noTaskTimeout, this.fatalCrashTimeout);
    }

    public String toString() {
        return "{betweenTaskTimeout=" + this.betweenTaskTimeout + ", noTaskTimeout=" + this.noTaskTimeout + ", fatalCrashTimeout=" + this.fatalCrashTimeout + '}';
    }

    @Override
    @Nonnull
    protected String getName() {
        return "pollSettings";
    }

    @Override
    @Nonnull
    protected BiFunction<PollSettings, PollSettings, String> getDiffEvaluator() {
        return (oldVal, newVal) -> {
            StringJoiner diff = new StringJoiner(",", this.getName() + '(', ")");
            if (!Objects.equals(oldVal.betweenTaskTimeout, newVal.betweenTaskTimeout)) {
                diff.add("betweenTaskTimeout=" + newVal.betweenTaskTimeout + '<' + oldVal.betweenTaskTimeout);
            }
            if (!Objects.equals(oldVal.noTaskTimeout, newVal.noTaskTimeout)) {
                diff.add("noTaskTimeout=" + newVal.noTaskTimeout + '<' + oldVal.noTaskTimeout);
            }
            if (!Objects.equals(oldVal.fatalCrashTimeout, newVal.fatalCrashTimeout)) {
                diff.add("fatalCrashTimeout=" + newVal.fatalCrashTimeout + '<' + oldVal.fatalCrashTimeout);
            }
            return diff.toString();
        };
    }

    @Override
    @Nonnull
    protected PollSettings getThis() {
        return this;
    }

    @Override
    protected void copyFields(@Nonnull PollSettings newValue) {
        this.betweenTaskTimeout = newValue.betweenTaskTimeout;
        this.noTaskTimeout = newValue.noTaskTimeout;
        this.fatalCrashTimeout = newValue.fatalCrashTimeout;
    }

    public static class Builder {
        private Duration betweenTaskTimeout;
        private Duration noTaskTimeout;
        private Duration fatalCrashTimeout;

        private Builder() {
        }

        public Builder withBetweenTaskTimeout(@Nonnull Duration betweenTaskTimeout) {
            this.betweenTaskTimeout = betweenTaskTimeout;
            return this;
        }

        public Builder withNoTaskTimeout(@Nonnull Duration noTaskTimeout) {
            this.noTaskTimeout = noTaskTimeout;
            return this;
        }

        public Builder withFatalCrashTimeout(@Nonnull Duration fatalCrashTimeout) {
            this.fatalCrashTimeout = fatalCrashTimeout;
            return this;
        }

        public PollSettings build() {
            return new PollSettings(this.betweenTaskTimeout, this.noTaskTimeout, this.fatalCrashTimeout);
        }
    }
}

