/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.PollSettings;

class PollSettingsParser {
    private final Supplier<PollSettings.Builder> defaultSettings;
    private final List<String> errorMessages;

    PollSettingsParser(Supplier<PollSettings.Builder> defaultSettings, List<String> errorMessages) {
        this.defaultSettings = defaultSettings;
        this.errorMessages = errorMessages;
    }

    Optional<PollSettings> parseSettings(@Nonnull String queueId, @Nonnull Map<String, String> settings) {
        Objects.requireNonNull(queueId, "queueId");
        Objects.requireNonNull(settings, "settings");
        try {
            PollSettings.Builder pollSettings = this.defaultSettings.get();
            settings.forEach((key, value) -> this.fillSettings(pollSettings, (String)key, (String)value));
            return Optional.of(pollSettings.build());
        }
        catch (RuntimeException exc) {
            this.errorMessages.add(String.format("cannot build poll settings: queueId=%s, msg=%s", queueId, exc.getMessage()));
            return Optional.empty();
        }
    }

    private void fillSettings(PollSettings.Builder pollSettings, String name, String value) {
        try {
            switch (name) {
                case "no-task-timeout": {
                    pollSettings.withNoTaskTimeout(Duration.parse(value));
                    return;
                }
                case "between-task-timeout": {
                    pollSettings.withBetweenTaskTimeout(Duration.parse(value));
                    return;
                }
                case "fatal-crash-timeout": {
                    pollSettings.withFatalCrashTimeout(Duration.parse(value));
                    return;
                }
            }
            return;
        }
        catch (RuntimeException exc) {
            this.errorMessages.add(String.format("cannot parse setting: name=%s, value=%s, exception=%s", name, value, exc.getClass().getSimpleName() + '(' + exc.getMessage() + ')'));
            return;
        }
    }
}

