/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.DynamicSetting;
import ru.yoomoney.tech.dbqueue.settings.ProcessingMode;

public class ProcessingSettings
extends DynamicSetting<ProcessingSettings> {
    @Nonnull
    private Integer threadCount;
    @Nonnull
    private ProcessingMode processingMode;

    private ProcessingSettings(@Nonnull Integer threadCount, @Nonnull ProcessingMode processingMode) {
        this.threadCount = Objects.requireNonNull(threadCount, "threadCount must not be null");
        this.processingMode = Objects.requireNonNull(processingMode, "processingMode must not be null");
        if (threadCount < 0) {
            throw new IllegalArgumentException("threadCount must not be negative");
        }
    }

    @Nonnull
    public Integer getThreadCount() {
        return this.threadCount;
    }

    @Nonnull
    public ProcessingMode getProcessingMode() {
        return this.processingMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    protected String getName() {
        return "processingSettings";
    }

    @Override
    @Nonnull
    protected BiFunction<ProcessingSettings, ProcessingSettings, String> getDiffEvaluator() {
        return (oldVal, newVal) -> {
            StringJoiner diff = new StringJoiner(",", this.getName() + '(', ")");
            if (!Objects.equals(oldVal.threadCount, newVal.threadCount)) {
                diff.add("threadCount=" + newVal.threadCount + '<' + oldVal.threadCount);
            }
            if (!Objects.equals((Object)oldVal.processingMode, (Object)newVal.processingMode)) {
                diff.add("processingMode=" + (Object)((Object)newVal.processingMode) + '<' + (Object)((Object)oldVal.processingMode));
            }
            return diff.toString();
        };
    }

    @Override
    @Nonnull
    protected ProcessingSettings getThis() {
        return this;
    }

    @Override
    protected void copyFields(@Nonnull ProcessingSettings newValue) {
        this.threadCount = newValue.threadCount;
        this.processingMode = newValue.processingMode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessingSettings that = (ProcessingSettings)obj;
        return this.threadCount.equals(that.threadCount) && this.processingMode == that.processingMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.threadCount, this.processingMode});
    }

    public String toString() {
        return "{threadCount=" + this.threadCount + ", processingMode=" + (Object)((Object)this.processingMode) + '}';
    }

    public static class Builder {
        private Integer threadCount;
        private ProcessingMode processingMode;

        private Builder() {
        }

        public Builder withThreadCount(@Nonnull Integer threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public Builder withProcessingMode(@Nonnull ProcessingMode processingMode) {
            this.processingMode = processingMode;
            return this;
        }

        public ProcessingSettings build() {
            return new ProcessingSettings(this.threadCount, this.processingMode);
        }
    }
}

