/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.ProcessingMode;
import ru.yoomoney.tech.dbqueue.settings.ProcessingSettings;

public class ProcessingSettingsParser {
    private final Supplier<ProcessingSettings.Builder> defaultSettings;
    private final List<String> errorMessages;

    ProcessingSettingsParser(@Nonnull Supplier<ProcessingSettings.Builder> defaultSettings, @Nonnull List<String> errorMessages) {
        this.defaultSettings = Objects.requireNonNull(defaultSettings, "defaultSettings");
        this.errorMessages = Objects.requireNonNull(errorMessages, "errorMessages");
    }

    Optional<ProcessingSettings> parseSettings(@Nonnull String queueId, @Nonnull Map<String, String> settings) {
        Objects.requireNonNull(queueId, "queueId");
        Objects.requireNonNull(settings, "settings");
        try {
            ProcessingSettings.Builder processingSettings = this.defaultSettings.get();
            settings.forEach((key, value) -> this.fillSettings(processingSettings, (String)key, (String)value));
            return Optional.of(processingSettings.build());
        }
        catch (RuntimeException exc) {
            this.errorMessages.add(String.format("cannot build processing settings: queueId=%s, msg=%s", queueId, exc.getMessage()));
            return Optional.empty();
        }
    }

    private void fillSettings(ProcessingSettings.Builder processingSettings, String name, String value) {
        try {
            switch (name) {
                case "thread-count": {
                    processingSettings.withThreadCount(Integer.valueOf(value));
                    return;
                }
                case "processing-mode": {
                    processingSettings.withProcessingMode(ProcessingSettingsParser.parseProcessingMode(value));
                    return;
                }
            }
        }
        catch (RuntimeException exc) {
            this.errorMessages.add(String.format("cannot parse setting: name=%s, value=%s, exception=%s", name, value, exc.getClass().getSimpleName() + '(' + exc.getMessage() + ')'));
        }
    }

    private static ProcessingMode parseProcessingMode(String name) {
        switch (name) {
            case "separate-transactions": {
                return ProcessingMode.SEPARATE_TRANSACTIONS;
            }
            case "wrap-in-transaction": {
                return ProcessingMode.WRAP_IN_TRANSACTION;
            }
            case "use-external-executor": {
                return ProcessingMode.USE_EXTERNAL_EXECUTOR;
            }
        }
        throw new IllegalArgumentException(String.format("unknown processing mode: name=%s", name));
    }
}

