/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.util.Objects;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;
import ru.yoomoney.tech.dbqueue.settings.QueueSettings;

public final class QueueConfig {
    @Nonnull
    private final QueueLocation location;
    @Nonnull
    private final QueueSettings settings;

    public QueueConfig(@Nonnull QueueLocation location, @Nonnull QueueSettings settings) {
        this.location = Objects.requireNonNull(location, "location must not be null");
        this.settings = Objects.requireNonNull(settings, "settings must not be null");
    }

    @Nonnull
    public QueueLocation getLocation() {
        return this.location;
    }

    @Nonnull
    public QueueSettings getSettings() {
        return this.settings;
    }

    public String toString() {
        return "{location=" + this.location + ", settings=" + this.settings + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueueConfig that = (QueueConfig)obj;
        return Objects.equals(this.location, that.location) && Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.settings);
    }
}

