/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.tech.dbqueue.settings.ExtSettings;
import ru.yoomoney.tech.dbqueue.settings.FailureSettings;
import ru.yoomoney.tech.dbqueue.settings.FailureSettingsParser;
import ru.yoomoney.tech.dbqueue.settings.PollSettings;
import ru.yoomoney.tech.dbqueue.settings.PollSettingsParser;
import ru.yoomoney.tech.dbqueue.settings.ProcessingSettings;
import ru.yoomoney.tech.dbqueue.settings.ProcessingSettingsParser;
import ru.yoomoney.tech.dbqueue.settings.QueueConfig;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;
import ru.yoomoney.tech.dbqueue.settings.QueueLocationParser;
import ru.yoomoney.tech.dbqueue.settings.QueueSettings;
import ru.yoomoney.tech.dbqueue.settings.ReenqueueSettings;
import ru.yoomoney.tech.dbqueue.settings.ReenqueueSettingsParser;

@ThreadSafe
public class QueueConfigsReader {
    private static final Logger log = LoggerFactory.getLogger(QueueConfigsReader.class);
    public static final String VALUE_TASK_RETRY_TYPE_GEOMETRIC = "geometric";
    public static final String VALUE_TASK_RETRY_TYPE_ARITHMETIC = "arithmetic";
    public static final String VALUE_TASK_RETRY_TYPE_LINEAR = "linear";
    public static final String VALUE_REENQUEUE_RETRY_TYPE_MANUAL = "manual";
    public static final String VALUE_REENQUEUE_RETRY_TYPE_FIXED = "fixed";
    public static final String VALUE_REENQUEUE_RETRY_TYPE_SEQUENTIAL = "sequential";
    public static final String VALUE_REENQUEUE_RETRY_TYPE_ARITHMETIC = "arithmetic";
    public static final String VALUE_REENQUEUE_RETRY_TYPE_GEOMETRIC = "geometric";
    public static final String VALUE_PROCESSING_MODE_USE_EXTERNAL_EXECUTOR = "use-external-executor";
    public static final String VALUE_PROCESSING_MODE_WRAP_IN_TRANSACTION = "wrap-in-transaction";
    public static final String VALUE_PROCESSING_MODE_SEPARATE_TRANSACTIONS = "separate-transactions";
    public static final String SETTING_PROCESSING_MODE = "processing-mode";
    public static final String SETTING_RETRY_TYPE = "retry-type";
    public static final String SETTING_RETRY_INTERVAL = "retry-interval";
    public static final String SETTING_REENQUEUE_RETRY_TYPE = "reenqueue-retry-type";
    public static final String SETTING_REENQUEUE_RETRY_PLAN = "reenqueue-retry-plan";
    public static final String SETTING_REENQUEUE_RETRY_DELAY = "reenqueue-retry-delay";
    public static final String SETTING_REENQUEUE_RETRY_INITIAL_DELAY = "reenqueue-retry-initial-delay";
    public static final String SETTING_REENQUEUE_RETRY_STEP = "reenqueue-retry-step";
    public static final String SETTING_REENQUEUE_RETRY_RATIO = "reenqueue-retry-ratio";
    public static final String SETTING_THREAD_COUNT = "thread-count";
    public static final String SETTING_FATAL_CRASH_TIMEOUT = "fatal-crash-timeout";
    public static final String SETTING_BETWEEN_TASK_TIMEOUT = "between-task-timeout";
    public static final String SETTING_NO_TASK_TIMEOUT = "no-task-timeout";
    public static final String SETTING_TABLE = "table";
    public static final String SETTING_ID_SEQUENCE = "id-sequence";
    public static final String SETTING_ADDITIONAL = "additional-settings";
    private final List<String> errorMessages = new ArrayList<String>();
    private static final Set<String> ALLOWED_SETTINGS = new HashSet<String>(Arrays.asList("processing-mode", "between-task-timeout", "table", "no-task-timeout", "id-sequence", "fatal-crash-timeout", "reenqueue-retry-delay", "reenqueue-retry-plan", "reenqueue-retry-initial-delay", "reenqueue-retry-ratio", "reenqueue-retry-type", "reenqueue-retry-step", "retry-type", "retry-interval", "thread-count", "thread-count"));
    @Nonnull
    private final List<Path> configPaths;
    @Nonnull
    private final String settingsPrefix;
    @Nonnull
    private final Supplier<ProcessingSettings.Builder> defaultProcessingSettings;
    @Nonnull
    private final Supplier<PollSettings.Builder> defaultPollSettings;
    @Nonnull
    private final Supplier<FailureSettings.Builder> defaultFailureSettings;
    @Nonnull
    private final Supplier<ReenqueueSettings.Builder> defaultReenqueueSettings;

    public QueueConfigsReader(@Nonnull List<Path> configPaths, @Nonnull String settingsPrefix) {
        this(configPaths, settingsPrefix, ProcessingSettings::builder, PollSettings::builder, FailureSettings::builder, ReenqueueSettings::builder);
    }

    public QueueConfigsReader(@Nonnull List<Path> configPaths, @Nonnull String settingsPrefix, @Nonnull Supplier<ProcessingSettings.Builder> defaultProcessingSettings, @Nonnull Supplier<PollSettings.Builder> defaultPollSettings, @Nonnull Supplier<FailureSettings.Builder> defaultFailureSettings, @Nonnull Supplier<ReenqueueSettings.Builder> defaultReenqueueSettings) {
        this.configPaths = Objects.requireNonNull(configPaths);
        this.settingsPrefix = Objects.requireNonNull(settingsPrefix);
        this.defaultProcessingSettings = Objects.requireNonNull(defaultProcessingSettings);
        this.defaultPollSettings = Objects.requireNonNull(defaultPollSettings);
        this.defaultFailureSettings = Objects.requireNonNull(defaultFailureSettings);
        this.defaultReenqueueSettings = Objects.requireNonNull(defaultReenqueueSettings);
        if (configPaths.isEmpty()) {
            throw new IllegalArgumentException("config paths must not be empty");
        }
        List illegalConfigs = configPaths.stream().filter(path -> !path.toFile().isFile()).collect(Collectors.toList());
        if (!illegalConfigs.isEmpty()) {
            throw new IllegalArgumentException("config path must be a file: files=" + illegalConfigs);
        }
    }

    @Nonnull
    public List<Path> getConfigPaths() {
        return new ArrayList<Path>(this.configPaths);
    }

    @Nonnull
    public List<QueueConfig> parse() {
        log.info("loading queue configuration: paths={}", this.configPaths);
        Path configPath = this.configPaths.get(0);
        Map<String, String> rawSettings = this.readRawSettings(configPath);
        if (this.configPaths.size() > 1) {
            List<Path> overrideConfigPaths = this.configPaths.subList(1, this.configPaths.size());
            overrideConfigPaths.stream().filter(Objects::nonNull).forEach(path -> QueueConfigsReader.overrideExistingSettings(rawSettings, this.readRawSettings((Path)path)));
        }
        Map<String, Map<String, String>> queues = this.splitRawSettingsByQueueId(rawSettings);
        QueueLocationParser queueLocationParser = new QueueLocationParser(this.errorMessages);
        ProcessingSettingsParser processingSettingsParser = new ProcessingSettingsParser(this.defaultProcessingSettings, this.errorMessages);
        PollSettingsParser pollSettingsParser = new PollSettingsParser(this.defaultPollSettings, this.errorMessages);
        ReenqueueSettingsParser reenqueueSettingsParser = new ReenqueueSettingsParser(this.defaultReenqueueSettings, this.errorMessages);
        FailureSettingsParser failureSettingsParser = new FailureSettingsParser(this.defaultFailureSettings, this.errorMessages);
        ArrayList<QueueConfig> queueConfigs = new ArrayList<QueueConfig>();
        queues.forEach((queueId, settings) -> {
            Optional<QueueLocation> queueLocation = queueLocationParser.parseQueueLocation((String)queueId, (Map<String, String>)settings);
            Optional<ProcessingSettings> processingSettings = processingSettingsParser.parseSettings((String)queueId, (Map<String, String>)settings);
            Optional<PollSettings> pollSettings = pollSettingsParser.parseSettings((String)queueId, (Map<String, String>)settings);
            Optional<FailureSettings> failureSettings = failureSettingsParser.parseSettings((String)queueId, (Map<String, String>)settings);
            Optional<ReenqueueSettings> reenqueueSettings = reenqueueSettingsParser.parseSettings((String)queueId, (Map<String, String>)settings);
            if (queueLocation.isPresent() && processingSettings.isPresent() && pollSettings.isPresent() && failureSettings.isPresent() && reenqueueSettings.isPresent()) {
                QueueSettings queueSettings = QueueSettings.builder().withProcessingSettings(processingSettings.get()).withPollSettings(pollSettings.get()).withFailureSettings(failureSettings.get()).withReenqueueSettings(reenqueueSettings.get()).withExtSettings(QueueConfigsReader.parseExtSettings(settings)).build();
                queueConfigs.add(new QueueConfig(queueLocation.get(), queueSettings));
            }
        });
        this.checkErrors();
        return queueConfigs;
    }

    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS"})
    private Map<String, String> readRawSettings(Path filePath) {
        Map<String, String> map;
        block9: {
            InputStream is = Files.newInputStream(filePath, new OpenOption[0]);
            try {
                Properties props = new Properties();
                props.load(is);
                LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>();
                for (String name : props.stringPropertyNames()) {
                    map2.put(name, props.getProperty(name));
                }
                map = this.cleanupProperties(map2);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("cannot read queue properties: file=" + filePath, ioe);
                }
            }
            is.close();
        }
        return map;
    }

    private Map<String, Map<String, String>> splitRawSettingsByQueueId(Map<String, String> rawSettings) {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        Pattern settingPattern = Pattern.compile(this.settingsPrefix + "\\.([A-Za-z0-9\\-_]+)\\.(.*)");
        rawSettings.forEach((setting, value) -> {
            Matcher matcher = settingPattern.matcher((CharSequence)setting);
            if (!matcher.matches()) {
                this.errorMessages.add(String.format("invalid format for setting name: setting=%s", setting));
            } else {
                String queueId = matcher.group(1);
                String settingName = matcher.group(2);
                result.computeIfAbsent(queueId, s -> new LinkedHashMap());
                ((Map)result.get(queueId)).put(settingName, value);
            }
        });
        this.validateSettings(result);
        this.checkErrors();
        return result;
    }

    @Nonnull
    private static ExtSettings parseExtSettings(Map<String, String> settings) {
        String extSettingsPrefix = "additional-settings.";
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> property : settings.entrySet()) {
            if (!property.getKey().startsWith(extSettingsPrefix)) continue;
            map.put(property.getKey().substring(extSettingsPrefix.length()), property.getValue());
        }
        return ExtSettings.builder().withSettings(map).build();
    }

    private void checkErrors() {
        if (!this.errorMessages.isEmpty()) {
            throw new IllegalArgumentException("Cannot parse queue settings:" + System.lineSeparator() + this.errorMessages.stream().sorted().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    private static void overrideExistingSettings(Map<String, String> existingSettings, Map<String, String> newSettings) {
        newSettings.forEach((key, newValue) -> {
            String existingValue = (String)existingSettings.get(key);
            if (existingValue != null) {
                log.info("overriding queue property: name={}, existingValue={}, newValue={}", new Object[]{key, existingValue, newValue});
            }
            existingSettings.put((String)key, (String)newValue);
        });
    }

    private Map<String, String> cleanupProperties(Map<String, String> rawProperties) {
        return rawProperties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(this.settingsPrefix)).filter(entry -> entry.getValue() != null && !((String)entry.getValue()).trim().isEmpty()).collect(Collectors.toMap(entry -> ((String)entry.getKey()).trim(), entry -> ((String)entry.getValue()).trim()));
    }

    private void validateSettings(Map<String, Map<String, String>> queuesSettings) {
        queuesSettings.forEach((queueId, settings) -> {
            for (String setting : settings.keySet()) {
                if (ALLOWED_SETTINGS.contains(setting) || setting.startsWith("additional-settings.")) continue;
                this.errorMessages.add(String.format("%s setting is unknown: queueId=%s", setting, queueId));
            }
        });
    }
}

