/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.tech.dbqueue.config.QueueService;
import ru.yoomoney.tech.dbqueue.settings.FileWatcher;
import ru.yoomoney.tech.dbqueue.settings.QueueConfig;
import ru.yoomoney.tech.dbqueue.settings.QueueConfigsReader;
import ru.yoomoney.tech.dbqueue.settings.QueueId;

public class QueueConfigsReloader {
    private static final Logger log = LoggerFactory.getLogger(QueueConfigsReloader.class);
    @Nonnull
    private final QueueConfigsReader queueConfigsReader;
    @Nonnull
    private final QueueService queueService;
    @Nonnull
    private final List<FileWatcher> fileWatchers;

    public QueueConfigsReloader(@Nonnull QueueConfigsReader queueConfigsReader, @Nonnull QueueService queueService) {
        this.queueConfigsReader = Objects.requireNonNull(queueConfigsReader, "queueConfigsReader");
        this.queueService = Objects.requireNonNull(queueService, "queueService");
        this.fileWatchers = queueConfigsReader.getConfigPaths().stream().map(path -> new FileWatcher((Path)path, this::reload)).collect(Collectors.toList());
    }

    private synchronized void reload() {
        try {
            List<QueueConfig> queueConfigs = this.queueConfigsReader.parse();
            Map<QueueId, String> diff = this.queueService.updateQueueConfigs(queueConfigs);
            log.info("queue configuration updated: diff={}", diff);
        }
        catch (RuntimeException exc) {
            log.error("cannot reload queue configs", (Throwable)exc);
        }
    }

    public synchronized void start() {
        this.fileWatchers.forEach(FileWatcher::startWatch);
    }

    public synchronized void stop() {
        this.fileWatchers.forEach(FileWatcher::stopWatch);
    }
}

