/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.yoomoney.tech.dbqueue.settings.QueueId;

public final class QueueLocation {
    private static final Pattern DISALLOWED_CHARS = Pattern.compile("[^a-zA-Z0-9_\\.]*");
    @Nonnull
    private final String tableName;
    @Nonnull
    private final QueueId queueId;
    @Nullable
    private final String idSequence;

    private QueueLocation(@Nonnull QueueId queueId, @Nonnull String tableName, @Nullable String idSequence) {
        this.queueId = Objects.requireNonNull(queueId, "queueId must not be null");
        this.tableName = DISALLOWED_CHARS.matcher(Objects.requireNonNull(tableName, "tableName must not be null")).replaceAll("");
        this.idSequence = idSequence != null ? DISALLOWED_CHARS.matcher(idSequence).replaceAll("") : null;
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Nonnull
    public QueueId getQueueId() {
        return this.queueId;
    }

    public Optional<String> getIdSequence() {
        return Optional.ofNullable(this.idSequence);
    }

    public String toString() {
        return "{id=" + this.queueId + ",table=" + this.tableName + (this.idSequence != null ? ",idSequence=" + this.idSequence : "") + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueueLocation that = (QueueLocation)obj;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.queueId, that.queueId) && Objects.equals(this.idSequence, that.idSequence);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.queueId, this.idSequence);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String tableName;
        private QueueId queueId;
        @Nullable
        private String idSequence;

        private Builder() {
        }

        public Builder withTableName(@Nonnull String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withQueueId(@Nonnull QueueId queueId) {
            this.queueId = queueId;
            return this;
        }

        public Builder withIdSequence(@Nullable String idSequence) {
            this.idSequence = idSequence;
            return this;
        }

        public QueueLocation build() {
            return new QueueLocation(this.queueId, this.tableName, this.idSequence);
        }
    }
}

