/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.QueueId;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

class QueueLocationParser {
    private final List<String> errorMessages;

    QueueLocationParser(@Nonnull List<String> errorMessages) {
        this.errorMessages = Objects.requireNonNull(errorMessages, "errorMessages");
    }

    Optional<QueueLocation> parseQueueLocation(@Nonnull String queueId, @Nonnull Map<String, String> settings) {
        Objects.requireNonNull(queueId, "queueId");
        Objects.requireNonNull(settings, "settings");
        try {
            QueueLocation.Builder queueLocation = QueueLocation.builder();
            queueLocation.withQueueId(new QueueId(queueId));
            settings.forEach((key, value) -> this.fillSettings(queueLocation, (String)key, (String)value));
            return Optional.of(queueLocation.build());
        }
        catch (RuntimeException exc) {
            this.errorMessages.add(String.format("cannot build queue location: queueId=%s, msg=%s", queueId, exc.getMessage()));
            return Optional.empty();
        }
    }

    private void fillSettings(QueueLocation.Builder queueLocation, String name, String value) {
        try {
            switch (name) {
                case "table": {
                    queueLocation.withTableName(value);
                    return;
                }
                case "id-sequence": {
                    queueLocation.withIdSequence(value);
                    return;
                }
            }
            return;
        }
        catch (RuntimeException exc) {
            this.errorMessages.add(String.format("cannot parse setting: name=%s, value=%s, exception=%s", name, value, exc.getClass().getSimpleName() + '(' + exc.getMessage() + ')'));
            return;
        }
    }
}

