/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.util.Objects;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.ExtSettings;
import ru.yoomoney.tech.dbqueue.settings.FailureSettings;
import ru.yoomoney.tech.dbqueue.settings.PollSettings;
import ru.yoomoney.tech.dbqueue.settings.ProcessingSettings;
import ru.yoomoney.tech.dbqueue.settings.ReenqueueSettings;

public final class QueueSettings {
    @Nonnull
    private final ProcessingSettings processingSettings;
    @Nonnull
    private final PollSettings pollSettings;
    @Nonnull
    private final FailureSettings failureSettings;
    @Nonnull
    private final ReenqueueSettings reenqueueSettings;
    @Nonnull
    private final ExtSettings extSettings;

    private QueueSettings(@Nonnull ProcessingSettings processingSettings, @Nonnull PollSettings pollSettings, @Nonnull FailureSettings failureSettings, @Nonnull ReenqueueSettings reenqueueSettings, @Nonnull ExtSettings extSettings) {
        this.processingSettings = Objects.requireNonNull(processingSettings, "processingSettings must not be null");
        this.pollSettings = Objects.requireNonNull(pollSettings, "pollSettings must not be null");
        this.failureSettings = Objects.requireNonNull(failureSettings, "failureSettings must not be null");
        this.reenqueueSettings = Objects.requireNonNull(reenqueueSettings, "reenqueueSettings must not be null");
        this.extSettings = Objects.requireNonNull(extSettings, "extSettings must not be null");
    }

    @Nonnull
    public ProcessingSettings getProcessingSettings() {
        return this.processingSettings;
    }

    @Nonnull
    public PollSettings getPollSettings() {
        return this.pollSettings;
    }

    @Nonnull
    public FailureSettings getFailureSettings() {
        return this.failureSettings;
    }

    @Nonnull
    public ReenqueueSettings getReenqueueSettings() {
        return this.reenqueueSettings;
    }

    @Nonnull
    public ExtSettings getExtSettings() {
        return this.extSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueueSettings that = (QueueSettings)obj;
        return this.processingSettings.equals(that.processingSettings) && this.pollSettings.equals(that.pollSettings) && this.failureSettings.equals(that.failureSettings) && this.reenqueueSettings.equals(that.reenqueueSettings) && this.extSettings.equals(that.extSettings);
    }

    public int hashCode() {
        return Objects.hash(this.processingSettings, this.pollSettings, this.failureSettings, this.reenqueueSettings, this.extSettings);
    }

    public String toString() {
        return "{processingSettings=" + this.processingSettings + ", pollSettings=" + this.pollSettings + ", failureSettings=" + this.failureSettings + ", reenqueueSettings=" + this.reenqueueSettings + ", additionalSettings=" + this.extSettings + '}';
    }

    public static class Builder {
        private ProcessingSettings processingSettings;
        private PollSettings pollSettings;
        private FailureSettings failureSettings;
        private ReenqueueSettings reenqueueSettings;
        private ExtSettings extSettings;

        private Builder() {
        }

        public Builder withProcessingSettings(@Nonnull ProcessingSettings processingSettings) {
            this.processingSettings = processingSettings;
            return this;
        }

        public Builder withPollSettings(@Nonnull PollSettings pollSettings) {
            this.pollSettings = pollSettings;
            return this;
        }

        public Builder withFailureSettings(@Nonnull FailureSettings failureSettings) {
            this.failureSettings = failureSettings;
            return this;
        }

        public Builder withReenqueueSettings(@Nonnull ReenqueueSettings reenqueueSettings) {
            this.reenqueueSettings = reenqueueSettings;
            return this;
        }

        public Builder withExtSettings(@Nonnull ExtSettings extSettings) {
            this.extSettings = extSettings;
            return this;
        }

        public QueueSettings build() {
            return new QueueSettings(this.processingSettings, this.pollSettings, this.failureSettings, this.reenqueueSettings, this.extSettings);
        }
    }
}

