/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.yoomoney.tech.dbqueue.settings.DynamicSetting;
import ru.yoomoney.tech.dbqueue.settings.ReenqueueRetryType;

public class ReenqueueSettings
extends DynamicSetting<ReenqueueSettings> {
    @Nonnull
    private ReenqueueRetryType retryType;
    @Nullable
    private List<Duration> sequentialPlan;
    @Nullable
    private Duration fixedDelay;
    @Nullable
    private Duration initialDelay;
    @Nullable
    private Duration arithmeticStep;
    @Nullable
    private Long geometricRatio;

    private ReenqueueSettings(@Nonnull ReenqueueRetryType retryType, @Nullable List<Duration> sequentialPlan, @Nullable Duration fixedDelay, @Nullable Duration initialDelay, @Nullable Duration arithmeticStep, @Nullable Long geometricRatio) {
        this.retryType = Objects.requireNonNull(retryType, "retryType must not be null");
        this.sequentialPlan = sequentialPlan;
        this.fixedDelay = fixedDelay;
        this.initialDelay = initialDelay;
        this.arithmeticStep = arithmeticStep;
        this.geometricRatio = geometricRatio;
        if (retryType == ReenqueueRetryType.SEQUENTIAL && (sequentialPlan == null || sequentialPlan.isEmpty())) {
            throw new IllegalArgumentException("sequentialPlan must not be empty when retryType=" + (Object)((Object)ReenqueueRetryType.SEQUENTIAL));
        }
        if (retryType == ReenqueueRetryType.FIXED && fixedDelay == null) {
            throw new IllegalArgumentException("fixedDelay must not be empty when retryType=" + (Object)((Object)ReenqueueRetryType.FIXED));
        }
        if (retryType == ReenqueueRetryType.ARITHMETIC && (arithmeticStep == null || initialDelay == null)) {
            throw new IllegalArgumentException("arithmeticStep and initialDelay must not be empty when retryType=" + (Object)((Object)ReenqueueRetryType.ARITHMETIC));
        }
        if (retryType == ReenqueueRetryType.GEOMETRIC && (geometricRatio == null || initialDelay == null)) {
            throw new IllegalArgumentException("geometricRatio and initialDelay must not be empty when retryType=" + (Object)((Object)ReenqueueRetryType.GEOMETRIC));
        }
    }

    @Nonnull
    public ReenqueueRetryType getRetryType() {
        return this.retryType;
    }

    @Nonnull
    public List<Duration> getSequentialPlanOrThrow() {
        if (this.sequentialPlan == null) {
            throw new IllegalStateException("sequential plan is null");
        }
        return this.sequentialPlan;
    }

    @Nonnull
    public Duration getFixedDelayOrThrow() {
        if (this.fixedDelay == null) {
            throw new IllegalStateException("fixed delay is null");
        }
        return this.fixedDelay;
    }

    @Nonnull
    public Duration getInitialDelayOrThrow() {
        if (this.initialDelay == null) {
            throw new IllegalStateException("initial delay is null");
        }
        return this.initialDelay;
    }

    @Nonnull
    public Duration getArithmeticStepOrThrow() {
        if (this.arithmeticStep == null) {
            throw new IllegalStateException("arithmetic step is null");
        }
        return this.arithmeticStep;
    }

    @Nonnull
    public Long getGeometricRatioOrThrow() {
        if (this.geometricRatio == null) {
            throw new IllegalStateException("geometric ratio is null");
        }
        return this.geometricRatio;
    }

    public String toString() {
        return "{retryType=" + (Object)((Object)this.retryType) + ", sequentialPlan=" + this.sequentialPlan + ", fixedDelay=" + this.fixedDelay + ", initialDelay=" + this.initialDelay + ", arithmeticStep=" + this.arithmeticStep + ", geometricRatio=" + this.geometricRatio + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReenqueueSettings that = (ReenqueueSettings)obj;
        return this.retryType == that.retryType && Objects.equals(this.sequentialPlan, that.sequentialPlan) && Objects.equals(this.fixedDelay, that.fixedDelay) && Objects.equals(this.initialDelay, that.initialDelay) && Objects.equals(this.arithmeticStep, that.arithmeticStep) && Objects.equals(this.geometricRatio, that.geometricRatio);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.retryType, this.sequentialPlan, this.fixedDelay, this.initialDelay, this.arithmeticStep, this.geometricRatio});
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    protected String getName() {
        return "reenqueueSettings";
    }

    @Override
    @Nonnull
    protected BiFunction<ReenqueueSettings, ReenqueueSettings, String> getDiffEvaluator() {
        return (oldVal, newVal) -> {
            StringJoiner diff = new StringJoiner(",", this.getName() + '(', ")");
            if (!Objects.equals((Object)oldVal.retryType, (Object)newVal.retryType)) {
                diff.add("type=" + (Object)((Object)newVal.retryType) + '<' + (Object)((Object)oldVal.retryType));
            }
            if (!Objects.equals(oldVal.arithmeticStep, newVal.arithmeticStep)) {
                diff.add("arithmeticStep=" + newVal.arithmeticStep + '<' + oldVal.arithmeticStep);
            }
            if (!Objects.equals(oldVal.geometricRatio, newVal.geometricRatio)) {
                diff.add("geometricRatio=" + newVal.geometricRatio + '<' + oldVal.geometricRatio);
            }
            if (!Objects.equals(oldVal.initialDelay, newVal.initialDelay)) {
                diff.add("initialDelay=" + newVal.initialDelay + '<' + oldVal.initialDelay);
            }
            if (!Objects.equals(oldVal.fixedDelay, newVal.fixedDelay)) {
                diff.add("fixedDelay=" + newVal.fixedDelay + '<' + oldVal.fixedDelay);
            }
            if (!Objects.equals(oldVal.sequentialPlan, newVal.sequentialPlan)) {
                diff.add("sequentialPlan=" + newVal.sequentialPlan + '<' + oldVal.sequentialPlan);
            }
            return diff.toString();
        };
    }

    @Override
    @Nonnull
    protected ReenqueueSettings getThis() {
        return this;
    }

    @Override
    protected void copyFields(@Nonnull ReenqueueSettings newValue) {
        this.retryType = newValue.retryType;
        this.arithmeticStep = newValue.arithmeticStep;
        this.geometricRatio = newValue.geometricRatio;
        this.fixedDelay = newValue.fixedDelay;
        this.initialDelay = newValue.initialDelay;
        this.sequentialPlan = newValue.sequentialPlan;
    }

    public static class Builder {
        private ReenqueueRetryType retryType;
        private List<Duration> sequentialPlan;
        private Duration fixedDelay;
        private Duration initialDelay;
        private Duration arithmeticStep;
        private Long geometricRatio;

        @Nonnull
        public Builder withRetryType(@Nonnull ReenqueueRetryType retryType) {
            this.retryType = retryType;
            return this;
        }

        @Nonnull
        public Builder withSequentialPlan(@Nullable List<Duration> sequentialPlan) {
            this.sequentialPlan = sequentialPlan;
            return this;
        }

        @Nonnull
        public Builder withFixedDelay(@Nullable Duration fixedDelay) {
            this.fixedDelay = fixedDelay;
            return this;
        }

        @Nonnull
        public Builder withInitialDelay(@Nullable Duration initialDelay) {
            this.initialDelay = initialDelay;
            return this;
        }

        @Nonnull
        public Builder withArithmeticStep(@Nullable Duration arithmeticStep) {
            this.arithmeticStep = arithmeticStep;
            return this;
        }

        @Nonnull
        public Builder withGeometricRatio(@Nullable Long geometricRatio) {
            this.geometricRatio = geometricRatio;
            return this;
        }

        @Nonnull
        public ReenqueueSettings build() {
            return new ReenqueueSettings(this.retryType, this.sequentialPlan, this.fixedDelay, this.initialDelay, this.arithmeticStep, this.geometricRatio);
        }
    }
}

