/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.settings.ReenqueueRetryType;
import ru.yoomoney.tech.dbqueue.settings.ReenqueueSettings;

class ReenqueueSettingsParser {
    private final Supplier<ReenqueueSettings.Builder> defaultSettings;
    private final List<String> errorMessages;

    ReenqueueSettingsParser(@Nonnull Supplier<ReenqueueSettings.Builder> defaultSettings, List<String> errorMessages) {
        this.defaultSettings = Objects.requireNonNull(defaultSettings, "defaultSettings");
        this.errorMessages = Objects.requireNonNull(errorMessages, "errorMessages");
    }

    Optional<ReenqueueSettings> parseSettings(@Nonnull String queueId, @Nonnull Map<String, String> settings) {
        Objects.requireNonNull(queueId, "queueId");
        Objects.requireNonNull(settings, "settings");
        try {
            ReenqueueSettings.Builder reenqueueSettings = this.defaultSettings.get();
            settings.forEach((key, value) -> this.fillSettings(reenqueueSettings, (String)key, (String)value));
            return Optional.of(reenqueueSettings.build());
        }
        catch (RuntimeException exc) {
            this.errorMessages.add(String.format("cannot build reenqueue settings: queueId=%s, msg=%s", queueId, exc.getMessage()));
            return Optional.empty();
        }
    }

    private void fillSettings(ReenqueueSettings.Builder builder, String name, String value) {
        try {
            switch (name) {
                case "reenqueue-retry-type": {
                    builder.withRetryType(ReenqueueSettingsParser.parseReenqueueRetryType(value));
                    return;
                }
                case "reenqueue-retry-plan": {
                    builder.withSequentialPlan(ReenqueueSettingsParser.parseReenqueueRetryPlan(value));
                    return;
                }
                case "reenqueue-retry-delay": {
                    builder.withFixedDelay(Duration.parse(value));
                    return;
                }
                case "reenqueue-retry-initial-delay": {
                    builder.withInitialDelay(Duration.parse(value));
                    return;
                }
                case "reenqueue-retry-step": {
                    builder.withArithmeticStep(Duration.parse(value));
                    return;
                }
                case "reenqueue-retry-ratio": {
                    builder.withGeometricRatio(Long.valueOf(value));
                    return;
                }
            }
        }
        catch (RuntimeException exc) {
            this.errorMessages.add(String.format("cannot parse setting: name=%s, value=%s, exception=%s", name, value, exc.getClass().getSimpleName() + '(' + exc.getMessage() + ')'));
        }
    }

    private static ReenqueueRetryType parseReenqueueRetryType(String type) {
        switch (type) {
            case "manual": {
                return ReenqueueRetryType.MANUAL;
            }
            case "fixed": {
                return ReenqueueRetryType.FIXED;
            }
            case "sequential": {
                return ReenqueueRetryType.SEQUENTIAL;
            }
            case "arithmetic": {
                return ReenqueueRetryType.ARITHMETIC;
            }
            case "geometric": {
                return ReenqueueRetryType.GEOMETRIC;
            }
        }
        throw new IllegalArgumentException(String.format("unknown reenqueue retry type: type=%s", type));
    }

    private static List<Duration> parseReenqueueRetryPlan(String plan) {
        String[] values = plan.split(",");
        return Arrays.stream(values).map(Duration::parse).collect(Collectors.toList());
    }
}

