/*
 * Decompiled with CFR 0.152.
 */
package se.sawano.eureka.legacyregistrar.boot;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import se.sawano.eureka.legacyregistrar.LegacyClient;
import se.sawano.eureka.legacyregistrar.boot.LegacyClientProperties;
import se.sawano.eureka.legacyregistrar.boot.LegacyClients;
import se.sawano.eureka.legacyregistrar.boot.LegacyInstances;
import se.sawano.eureka.legacyregistrar.boot.SpringBootClientConfig;
import se.sawano.eureka.legacyregistrar.boot.SpringBootInstanceConfig;
import se.sawano.java.commons.lang.validate.Validate;

@Configuration
@EnableConfigurationProperties(value={LegacyInstances.class, LegacyClientProperties.class})
public class LegacyRegistrarConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private LegacyInstances instances;
    @Autowired
    private LegacyClientProperties properties;

    @Bean
    public LegacyClients legacyClients() {
        Validate.isFalse((boolean)this.instances.getInstances().isEmpty(), (String)"No applications configured. Make sure your application.yml is present and configured correctly");
        Validate.noNullElements(this.instances.getInstances());
        List clients = this.instances.getInstances().stream().map(this::createInstance).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        return new LegacyClients(clients);
    }

    @PreDestroy
    public void shutdown() {
        this.legacyClients().clients().forEach(this::shutdown);
    }

    private LegacyClient createInstance(SpringBootInstanceConfig instanceConfig) {
        this.logger.debug("Creating legacy instance for app instance: '{}'", (Object)instanceConfig.getInstanceId());
        LegacyClient client = new LegacyClient(instanceConfig, new SpringBootClientConfig(this.properties));
        client.init();
        return client;
    }

    private void shutdown(LegacyClient client) {
        try {
            client.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

