/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture;

import fitnesse.slim.StatementExecutorConsumer;
import fitnesse.slim.StatementExecutorInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smartrics.rest.client.RestClient;
import smartrics.rest.client.RestRequest;
import smartrics.rest.client.RestResponse;
import smartrics.rest.fitnesse.fixture.PartsFactory;
import smartrics.rest.fitnesse.fixture.RunnerVariablesProvider;
import smartrics.rest.fitnesse.fixture.SlimRow;
import smartrics.rest.fitnesse.fixture.support.BodyTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.CellFormatter;
import smartrics.rest.fitnesse.fixture.support.CellWrapper;
import smartrics.rest.fitnesse.fixture.support.Config;
import smartrics.rest.fitnesse.fixture.support.ContentType;
import smartrics.rest.fitnesse.fixture.support.FitVariables;
import smartrics.rest.fitnesse.fixture.support.HeadersTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.JavascriptException;
import smartrics.rest.fitnesse.fixture.support.JavascriptWrapper;
import smartrics.rest.fitnesse.fixture.support.LetHandler;
import smartrics.rest.fitnesse.fixture.support.LetHandlerFactory;
import smartrics.rest.fitnesse.fixture.support.RestDataTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.RowWrapper;
import smartrics.rest.fitnesse.fixture.support.SlimVariables;
import smartrics.rest.fitnesse.fixture.support.StatusCodeTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.StringTypeAdapter;
import smartrics.rest.fitnesse.fixture.support.Tools;
import smartrics.rest.fitnesse.fixture.support.Url;
import smartrics.rest.fitnesse.fixture.support.Variables;

public class RestFixture
implements StatementExecutorConsumer,
RunnerVariablesProvider {
    private static final String LINE_SEPARATOR = "\n";
    private static final String FILE = "file";
    private static final Logger LOG = LoggerFactory.getLogger(RestFixture.class);
    protected Variables GLOBALS;
    private RestResponse lastResponse;
    private RestRequest lastRequest;
    protected String fileName = null;
    protected String multipartFileName = null;
    protected String multipartFileParameterName = "file";
    protected String requestBody;
    protected boolean resourceUrisAreEscaped = false;
    protected Map<String, String> requestHeaders;
    private RestClient restClient;
    private Config config;
    private Runner runner;
    private boolean displayActualOnRight;
    private boolean displayAbsoluteURLInFull;
    private boolean debugMethodCall = false;
    private Map<String, String> defaultHeaders = new HashMap<String, String>();
    private Map<String, String> namespaceContext = new HashMap<String, String>();
    private Url baseUrl;
    protected RowWrapper row;
    private CellFormatter<?> formatter;
    private PartsFactory partsFactory;
    private String lastEvaluation;
    private int minLenForCollapseToggle;
    private boolean followRedirects = true;
    private StatementExecutorInterface slimStatementExecutor;

    @Override
    public Variables createRunnerVariables() {
        switch (this.runner) {
            case SLIM: {
                return new SlimVariables(this.config, this.slimStatementExecutor);
            }
            case FIT: {
                return new FitVariables(this.config);
            }
        }
        return new FitVariables(this.config);
    }

    public RestFixture() {
        this.partsFactory = new PartsFactory(this, Config.getConfig("default"));
        this.displayActualOnRight = true;
        this.minLenForCollapseToggle = -1;
        this.resourceUrisAreEscaped = false;
        this.displayAbsoluteURLInFull = true;
        this.requestHeaders = new LinkedHashMap<String, String>();
    }

    public RestFixture(String hostName) {
        this(hostName, "default");
    }

    public RestFixture(String hostName, String configName) {
        this.displayActualOnRight = true;
        this.minLenForCollapseToggle = -1;
        this.resourceUrisAreEscaped = false;
        this.displayAbsoluteURLInFull = true;
        this.config = Config.getConfig(configName);
        this.partsFactory = new PartsFactory(this, this.config);
        this.baseUrl = new Url(this.stripTag(hostName));
        this.requestHeaders = new LinkedHashMap<String, String>();
    }

    RestFixture(PartsFactory partsFactory, String hostName, String configName) {
        this.displayActualOnRight = true;
        this.minLenForCollapseToggle = -1;
        this.resourceUrisAreEscaped = false;
        this.displayAbsoluteURLInFull = true;
        this.partsFactory = partsFactory;
        this.config = Config.getConfig(configName);
        this.baseUrl = new Url(this.stripTag(hostName));
        this.requestHeaders = new LinkedHashMap<String, String>();
    }

    public Config getConfig() {
        return this.config;
    }

    public String getLastEvaluation() {
        return this.lastEvaluation;
    }

    public String getBaseUrl() {
        if (this.baseUrl != null) {
            return this.baseUrl.toString();
        }
        return null;
    }

    public void setBaseUrl(Url url) {
        this.baseUrl = url;
    }

    public void baseUrl(String url) {
        this.setBaseUrl(new Url(url));
    }

    public Map<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public CellFormatter<?> getFormatter() {
        return this.formatter;
    }

    public List<List<String>> doTable(List<List<String>> rows) {
        this.initialize(Runner.SLIM);
        Vector<List<String>> res = new Vector<List<String>>();
        this.getFormatter().setDisplayActual(this.displayActualOnRight);
        this.getFormatter().setDisplayAbsoluteURLInFull(this.displayAbsoluteURLInFull);
        this.getFormatter().setMinLengthForToggleCollapse(this.minLenForCollapseToggle);
        for (List<String> r : rows) {
            this.processSlimRow(res, r);
        }
        return res;
    }

    protected boolean validateState() {
        return this.baseUrl != null;
    }

    protected void setConfig(Config c) {
        this.config = c;
    }

    protected void notifyInvalidState(boolean state) {
        if (!state) {
            throw new RuntimeException("You must specify a base url in the |start|, after the fixture to start");
        }
    }

    public void setMultipartFileName() {
        CellWrapper cell = this.row.getCell(1);
        if (cell == null) {
            this.getFormatter().exception(this.row.getCell(0), "You must pass a multipart file name to set");
        } else {
            this.multipartFileName = this.GLOBALS.substitute(cell.text());
            this.renderReplacement(cell, this.multipartFileName);
        }
    }

    public String getMultipartFileName() {
        return this.multipartFileName;
    }

    public void setFileName() {
        CellWrapper cell = this.row.getCell(1);
        if (cell == null) {
            this.getFormatter().exception(this.row.getCell(0), "You must pass a file name to set");
        } else {
            this.fileName = this.GLOBALS.substitute(cell.text());
            this.renderReplacement(cell, this.fileName);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setMultipartFileParameterName() {
        CellWrapper cell = this.row.getCell(1);
        if (cell == null) {
            this.getFormatter().exception(this.row.getCell(0), "You must pass a parameter name to set");
        } else {
            this.multipartFileParameterName = this.GLOBALS.substitute(cell.text());
            this.renderReplacement(cell, this.multipartFileParameterName);
        }
    }

    public String getMultipartFileParameterName() {
        return this.multipartFileParameterName;
    }

    public void setBody() {
        CellWrapper cell = this.row.getCell(1);
        if (cell == null) {
            this.getFormatter().exception(this.row.getCell(0), "You must pass a body to set");
        } else {
            String text = this.getFormatter().fromRaw(cell.text());
            this.requestBody = this.GLOBALS.substitute(text);
            this.renderReplacement(cell, this.requestBody);
        }
    }

    public String setBody(String body) {
        this.requestBody = body;
        if (this.GLOBALS != null) {
            this.requestBody = this.GLOBALS.substitute(body);
        }
        return this.requestBody;
    }

    public void setHeader() {
        this.requestHeaders.clear();
        this.addHeader();
    }

    public void addHeader() {
        CellWrapper cell = this.row.getCell(1);
        if (cell == null) {
            this.getFormatter().exception(this.row.getCell(0), "You must pass a header map to set");
        } else {
            String substitutedHeaders = this.GLOBALS.substitute(cell.text());
            this.requestHeaders.putAll(this.parseHeaders(substitutedHeaders));
            cell.body(this.getFormatter().gray(substitutedHeaders));
        }
    }

    public Map<String, String> addHeader(String headers) {
        String substitutedHeaders = headers;
        if (this.GLOBALS != null) {
            substitutedHeaders = this.GLOBALS.substitute(headers);
        }
        this.requestHeaders.putAll(this.parseHeaders(substitutedHeaders));
        return this.requestHeaders;
    }

    public Map<String, String> setHeader(String headers) {
        this.requestHeaders = new LinkedHashMap<String, String>();
        return this.addHeader(headers);
    }

    public Map<String, String> setHeaders(String headers) {
        return this.setHeader(headers);
    }

    public void setHeaders() {
        this.setHeader();
    }

    public void addHeaders() {
        this.addHeader();
    }

    public void PUT() {
        this.debugMethodCallStart();
        this.doMethod(this.emptifyBody(this.requestBody), "Put");
        this.debugMethodCallEnd();
    }

    public void GET() {
        this.debugMethodCallStart();
        this.doMethod("Get");
        this.debugMethodCallEnd();
    }

    public void HEAD() {
        this.debugMethodCallStart();
        this.doMethod("Head");
        this.debugMethodCallEnd();
    }

    public void OPTIONS() {
        this.debugMethodCallStart();
        this.doMethod("Options");
        this.debugMethodCallEnd();
    }

    public void DELETE() {
        this.debugMethodCallStart();
        this.doMethod("Delete");
        this.debugMethodCallEnd();
    }

    public void TRACE() {
        this.debugMethodCallStart();
        this.doMethod("Trace");
        this.debugMethodCallEnd();
    }

    public void POST() {
        this.debugMethodCallStart();
        this.doMethod(this.emptifyBody(this.requestBody), "Post");
        this.debugMethodCallEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void let() {
        block9: {
            this.debugMethodCallStart();
            if (this.row.size() != 5) {
                this.getFormatter().exception(this.row.getCell(this.row.size() - 1), "Not all cells found: | let | label | type | expr | result |");
                this.debugMethodCallEnd();
                return;
            }
            String label = this.row.getCell(1).text().trim();
            String loc = this.row.getCell(2).text();
            CellWrapper exprCell = this.row.getCell(3);
            try {
                exprCell.body(this.GLOBALS.substitute(exprCell.body()));
                String expr = exprCell.text();
                CellWrapper valueCell = this.row.getCell(4);
                String valueCellText = valueCell.body();
                String valueCellTextReplaced = this.GLOBALS.substitute(valueCellText);
                valueCell.body(valueCellTextReplaced);
                String sValue = null;
                LetHandler letHandler = LetHandlerFactory.getHandlerFor(loc);
                if (letHandler != null) {
                    StringTypeAdapter adapter = new StringTypeAdapter();
                    try {
                        sValue = letHandler.handle(this, this.config, this.getLastResponse(), this.namespaceContext, expr);
                        exprCell.body(this.getFormatter().gray(exprCell.body()));
                    }
                    catch (RuntimeException e) {
                        this.getFormatter().exception(exprCell, e.getMessage());
                        LOG.error("Exception occurred when processing cell=" + exprCell, (Throwable)e);
                    }
                    this.GLOBALS.put(label, sValue);
                    adapter.set(sValue);
                    this.getFormatter().check(valueCell, adapter);
                    break block9;
                }
                this.getFormatter().exception(exprCell, "I don't know how to process the expression for '" + loc + "'");
            }
            catch (RuntimeException e) {
                this.getFormatter().exception(exprCell, e);
            }
            finally {
                this.debugMethodCallEnd();
            }
        }
    }

    public void comment() {
        this.debugMethodCallStart();
        CellWrapper messageCell = this.row.getCell(1);
        try {
            String message = messageCell.text().trim();
            message = this.GLOBALS.substitute(message);
            messageCell.body(this.getFormatter().gray(message));
        }
        catch (RuntimeException e) {
            this.getFormatter().exception(messageCell, e);
        }
        finally {
            this.debugMethodCallEnd();
        }
    }

    public void evalJs() {
        CellWrapper jsCell = this.row.getCell(1);
        if (jsCell == null) {
            this.getFormatter().exception(this.row.getCell(0), "Missing string to evaluate)");
            return;
        }
        JavascriptWrapper wrapper = new JavascriptWrapper(this);
        Object result = null;
        try {
            result = wrapper.evaluateExpression(this.lastResponse, jsCell.body());
        }
        catch (JavascriptException e) {
            this.getFormatter().exception(this.row.getCell(1), e);
            return;
        }
        this.lastEvaluation = null;
        if (result != null) {
            this.lastEvaluation = result.toString();
        }
        StringTypeAdapter adapter = new StringTypeAdapter();
        adapter.set(this.lastEvaluation);
        this.getFormatter().right(this.row.getCell(1), adapter);
    }

    public void processRow(RowWrapper<?> currentRow) {
        this.row = currentRow;
        CellWrapper cell0 = this.row.getCell(0);
        if (cell0 == null) {
            throw new RuntimeException("Current RestFixture row is not parseable (maybe empty or not existent)");
        }
        String methodName = cell0.text();
        if ("".equals(methodName)) {
            throw new RuntimeException("RestFixture method not specified");
        }
        try {
            Method method1 = this.getClass().getMethod(methodName, new Class[0]);
            method1.invoke((Object)this, new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Not enough permissions to access method " + methodName + " for this class " + this.getClass().getSimpleName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Class " + this.getClass().getName() + " doesn't have a callable method named " + methodName, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Method named " + methodName + " invoked with the wrong argument.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Method named " + methodName + " is not public.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Method named " + methodName + " threw an exception when executing.", e);
        }
    }

    protected void initialize(Runner runner) {
        this.runner = runner;
        boolean state = this.validateState();
        this.notifyInvalidState(state);
        this.configFormatter();
        this.configFixture();
        this.configRestClient();
    }

    protected String emptifyBody(String b) {
        String body = b;
        if (body == null) {
            body = "";
        }
        return body;
    }

    public Map<String, String> getHeaders() {
        Map<String, String> headers = null;
        headers = this.requestHeaders != null ? this.requestHeaders : this.defaultHeaders;
        return headers;
    }

    protected String getRequestBody() {
        return this.requestBody;
    }

    protected void setRequestBody(String text) {
        this.requestBody = text;
    }

    protected Map<String, String> getNamespaceContext() {
        return this.namespaceContext;
    }

    private void doMethod(String m) {
        this.doMethod(null, m);
    }

    protected void doMethod(String body, String method) {
        CellWrapper urlCell = this.row.getCell(1);
        String url = this.deHtmlify(this.stripTag(urlCell.text()));
        String resUrl = this.GLOBALS.substitute(url);
        String rBody = this.GLOBALS.substitute(body);
        Map<String, String> rHeaders = this.substitute(this.getHeaders());
        try {
            this.doMethod(method, resUrl, rHeaders, rBody);
            this.completeHttpMethodExecution();
        }
        catch (RuntimeException e) {
            this.getFormatter().exception(this.row.getCell(0), "Execution of " + method + " caused exception '" + e.getMessage() + "'");
            LOG.error("Exception occurred when processing method=" + method, (Throwable)e);
        }
    }

    protected void doMethod(String method, String resUrl, String rBody) {
        this.doMethod(method, resUrl, this.substitute(this.getHeaders()), rBody);
    }

    protected void doMethod(String method, String resUrl, Map<String, String> headers, String rBody) {
        this.setLastRequest(this.partsFactory.buildRestRequest());
        this.getLastRequest().setMethod(RestRequest.Method.valueOf((String)method));
        this.getLastRequest().addHeaders(headers);
        this.getLastRequest().setFollowRedirect(this.followRedirects);
        this.getLastRequest().setResourceUriEscaped(this.resourceUrisAreEscaped);
        if (this.fileName != null) {
            this.getLastRequest().setFileName(this.fileName);
        }
        if (this.multipartFileName != null) {
            this.getLastRequest().setMultipartFileName(this.multipartFileName);
        }
        this.getLastRequest().setMultipartFileParameterName(this.multipartFileParameterName);
        String[] uri = resUrl.split("\\?", 2);
        String[] thisRequestUrlParts = this.buildThisRequestUrl(uri[0]);
        this.getLastRequest().setResource(thisRequestUrlParts[1]);
        if (uri.length > 1) {
            String query = uri[1];
            for (int i = 2; i < uri.length; ++i) {
                query = query + "?" + uri[i];
            }
            this.getLastRequest().setQuery(query);
        }
        if ("Post".equals(method) || "Put".equals(method)) {
            this.getLastRequest().setBody(rBody);
        }
        this.configureCredentials();
        this.restClient.setBaseUrl(thisRequestUrlParts[0]);
        RestResponse response = this.restClient.execute(this.getLastRequest());
        this.setLastResponse(response);
    }

    protected void completeHttpMethodExecution() {
        String uri = this.getLastResponse().getResource();
        String query = this.getLastRequest().getQuery();
        if (query != null && !"".equals(query.trim())) {
            uri = uri + "?" + query;
        }
        String clientBaseUri = this.restClient.getBaseUrl();
        String u = clientBaseUri + uri;
        CellWrapper uriCell = this.row.getCell(1);
        this.getFormatter().asLink(uriCell, this.GLOBALS.substitute(uriCell.body()), u, uri);
        CellWrapper cellStatusCode = this.row.getCell(2);
        if (cellStatusCode == null) {
            throw new IllegalStateException("You must specify a status code cell");
        }
        Integer lastStatusCode = this.getLastResponse().getStatusCode();
        this.process(cellStatusCode, lastStatusCode.toString(), new StatusCodeTypeAdapter());
        List lastHeaders = this.getLastResponse().getHeaders();
        this.process(this.row.getCell(3), lastHeaders, new HeadersTypeAdapter());
        CellWrapper bodyCell = this.row.getCell(4);
        if (bodyCell == null) {
            throw new IllegalStateException("You must specify a body cell");
        }
        bodyCell.body(this.GLOBALS.substitute(bodyCell.body()));
        BodyTypeAdapter bodyTypeAdapter = this.createBodyTypeAdapter();
        this.process(bodyCell, this.getLastResponse().getBody(), bodyTypeAdapter);
    }

    protected BodyTypeAdapter createBodyTypeAdapter() {
        return this.createBodyTypeAdapter(ContentType.parse(this.getLastResponse().getContentType()));
    }

    protected BodyTypeAdapter createBodyTypeAdapter(ContentType ct) {
        String charset = this.getLastResponse().getCharset();
        BodyTypeAdapter bodyTypeAdapter = this.partsFactory.buildBodyTypeAdapter(ct, charset);
        bodyTypeAdapter.setContext(this.namespaceContext);
        return bodyTypeAdapter;
    }

    private void process(CellWrapper expected, Object actual, RestDataTypeAdapter ta) {
        if (expected == null) {
            throw new IllegalStateException("You must specify a headers cell");
        }
        ta.set(actual);
        boolean ignore = "".equals(expected.text().trim());
        if (ignore) {
            String actualString = ta.toString();
            if (!"".equals(actualString)) {
                expected.addToBody(this.getFormatter().gray(actualString));
            }
        } else {
            boolean success = false;
            try {
                String substitute = this.GLOBALS.substitute(Tools.fromHtml(expected.text()));
                Object parse = ta.parse(substitute);
                success = ta.equals(parse, actual);
            }
            catch (Exception e) {
                this.getFormatter().exception(expected, e);
                return;
            }
            if (success) {
                this.getFormatter().right(expected, ta);
            } else {
                this.getFormatter().wrong(expected, ta);
            }
        }
    }

    private void debugMethodCallStart() {
        this.debugMethodCall("=> ");
    }

    private void debugMethodCallEnd() {
        this.debugMethodCall("<= ");
    }

    private void debugMethodCall(String h) {
        if (this.debugMethodCall) {
            StackTraceElement el = Thread.currentThread().getStackTrace()[4];
            LOG.debug(h + el.getMethodName());
        }
    }

    private Map<String, String> substitute(Map<String, String> headers) {
        HashMap<String, String> sub = new HashMap<String, String>();
        for (Map.Entry<String, String> e : headers.entrySet()) {
            sub.put(e.getKey(), this.GLOBALS.substitute(e.getValue()));
        }
        return sub;
    }

    protected RestResponse getLastResponse() {
        return this.lastResponse;
    }

    protected RestRequest getLastRequest() {
        return this.lastRequest;
    }

    private String[] buildThisRequestUrl(String uri) {
        String[] parts = new String[2];
        if (this.baseUrl == null || uri.startsWith(this.baseUrl.toString())) {
            Url url = new Url(uri);
            parts[0] = url.getBaseUrl();
            parts[1] = url.getResource();
        } else {
            try {
                Url attempted = new Url(uri);
                parts[0] = attempted.getBaseUrl();
                parts[1] = attempted.getResource();
            }
            catch (RuntimeException e) {
                parts[0] = this.baseUrl.toString();
                parts[1] = uri;
            }
        }
        return parts;
    }

    private void setLastResponse(RestResponse lastResponse) {
        this.lastResponse = lastResponse;
    }

    private void setLastRequest(RestRequest lastRequest) {
        this.lastRequest = lastRequest;
    }

    protected Map<String, String> parseHeaders(String str) {
        return Tools.convertStringToMap(str, ":", LINE_SEPARATOR, true);
    }

    private Map<String, String> parseNamespaceContext(String str) {
        return Tools.convertStringToMap(str, "=", LINE_SEPARATOR, true);
    }

    private String stripTag(String somethingWithinATag) {
        return Tools.fromSimpleTag(somethingWithinATag);
    }

    private void configFormatter() {
        this.formatter = this.partsFactory.buildCellFormatter(this.runner);
    }

    private void configFixture() {
        this.GLOBALS = this.createRunnerVariables();
        this.displayActualOnRight = this.config.getAsBoolean("restfixture.display.actual.on.right", this.displayActualOnRight);
        this.displayAbsoluteURLInFull = this.config.getAsBoolean("restfixture.display.absolute.url.in.full", this.displayAbsoluteURLInFull);
        this.resourceUrisAreEscaped = this.config.getAsBoolean("restfixture.resource.uris.are.escaped", this.resourceUrisAreEscaped);
        this.followRedirects = this.config.getAsBoolean("restfixture.requests.follow.redirects", this.followRedirects);
        this.minLenForCollapseToggle = this.config.getAsInteger("restfixture.display.toggle.for.cells.larger.than", this.minLenForCollapseToggle);
        String str = this.config.get("restfixture.default.headers", "");
        this.defaultHeaders = this.parseHeaders(str);
        str = this.config.get("restfixture.xml.namespace.context", "");
        this.namespaceContext = this.parseNamespaceContext(str);
        ContentType.resetDefaultMapping();
        ContentType.config(this.config);
    }

    private void configRestClient() {
        this.restClient = this.partsFactory.buildRestClient(this.getConfig());
    }

    private void renderReplacement(CellWrapper cell, String actual) {
        StringTypeAdapter adapter = new StringTypeAdapter();
        adapter.set(actual);
        if (!adapter.equals(actual, cell.body())) {
            cell.body(actual);
            this.getFormatter().right(cell, adapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSlimRow(List<List<String>> resultTable, List<String> row) {
        SlimRow currentRow = new SlimRow(row);
        try {
            this.processRow(currentRow);
        }
        catch (Exception e) {
            LOG.error("Exception raised when processing row " + row.get(0), (Throwable)e);
            this.getFormatter().exception(currentRow.getCell(0), e);
        }
        finally {
            List<String> rowAsList = this.mapSlimRow(row, currentRow);
            resultTable.add(rowAsList);
        }
    }

    private List<String> mapSlimRow(List<String> resultRow, RowWrapper currentRow) {
        List<String> rowAsList = ((SlimRow)currentRow).asList();
        for (int c = 0; c < rowAsList.size(); ++c) {
            String v = rowAsList.get(c);
            if (!v.equals(resultRow.get(c))) continue;
            rowAsList.set(c, "");
        }
        return rowAsList;
    }

    private String deHtmlify(String someHtml) {
        return Tools.fromHtml(someHtml);
    }

    private void configureCredentials() {
        String username = this.config.get("http.basicauth.username");
        String password = this.config.get("http.basicauth.password");
        if (username != null && password != null) {
            String newUsername = this.GLOBALS.substitute(username);
            String newPassword = this.GLOBALS.substitute(password);
            Config newConfig = this.getConfig();
            newConfig.add("http.basicauth.username", newUsername);
            newConfig.add("http.basicauth.password", newPassword);
            this.restClient = this.partsFactory.buildRestClient(newConfig);
        }
    }

    public void setStatementExecutor(StatementExecutorInterface arg0) {
        this.slimStatementExecutor = arg0;
    }

    public static enum Runner {
        SLIM,
        FIT,
        OTHER;

    }
}

