/*
 * Decompiled with CFR 0.152.
 */
package smartrics.rest.fitnesse.fixture.support;

import java.net.MalformedURLException;
import java.net.URL;

public class Url {
    private URL baseUrl;

    public Url(String url) {
        try {
            if (url == null || "".equals(url.trim())) {
                throw new IllegalArgumentException("Null or empty input: " + url);
            }
            String u = url;
            if (url.endsWith("/")) {
                u = url.substring(0, u.length() - 1);
            }
            this.baseUrl = new URL(u);
            if ("".equals(this.baseUrl.getHost())) {
                throw new IllegalArgumentException("No host specified in base URL: " + url);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed base URL: " + url, e);
        }
    }

    public URL getUrl() {
        return this.baseUrl;
    }

    public String toString() {
        return this.getUrl().toExternalForm();
    }

    public String getResource() {
        String res = this.getUrl().getPath().trim();
        if (res.isEmpty()) {
            return "/";
        }
        return res;
    }

    public String getBaseUrl() {
        String path = this.getResource().trim();
        if (path.length() == 0 || path.equals("/")) {
            return this.toString();
        }
        int index = this.toString().indexOf(this.getResource());
        if (index >= 0) {
            return this.toString().substring(0, index);
        }
        throw new IllegalStateException("Invalid URL");
    }

    public URL buildURL(String file) {
        try {
            return new URL(this.baseUrl, file);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL part: " + file);
        }
    }
}

