/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.RecommendedRemediationAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnusedPermissionsRecommendedStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnusedPermissionsRecommendedStep> {
    private static final SdkField<Instant> POLICY_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("policyUpdatedAt").getter(UnusedPermissionsRecommendedStep.getter(UnusedPermissionsRecommendedStep::policyUpdatedAt)).setter(UnusedPermissionsRecommendedStep.setter(Builder::policyUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> RECOMMENDED_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedAction").getter(UnusedPermissionsRecommendedStep.getter(UnusedPermissionsRecommendedStep::recommendedActionAsString)).setter(UnusedPermissionsRecommendedStep.setter(Builder::recommendedAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedAction").build()}).build();
    private static final SdkField<String> RECOMMENDED_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedPolicy").getter(UnusedPermissionsRecommendedStep.getter(UnusedPermissionsRecommendedStep::recommendedPolicy)).setter(UnusedPermissionsRecommendedStep.setter(Builder::recommendedPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedPolicy").build()}).build();
    private static final SdkField<String> EXISTING_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("existingPolicyId").getter(UnusedPermissionsRecommendedStep.getter(UnusedPermissionsRecommendedStep::existingPolicyId)).setter(UnusedPermissionsRecommendedStep.setter(Builder::existingPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingPolicyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_UPDATED_AT_FIELD, RECOMMENDED_ACTION_FIELD, RECOMMENDED_POLICY_FIELD, EXISTING_POLICY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant policyUpdatedAt;
    private final String recommendedAction;
    private final String recommendedPolicy;
    private final String existingPolicyId;

    private UnusedPermissionsRecommendedStep(BuilderImpl builder) {
        this.policyUpdatedAt = builder.policyUpdatedAt;
        this.recommendedAction = builder.recommendedAction;
        this.recommendedPolicy = builder.recommendedPolicy;
        this.existingPolicyId = builder.existingPolicyId;
    }

    public final Instant policyUpdatedAt() {
        return this.policyUpdatedAt;
    }

    public final RecommendedRemediationAction recommendedAction() {
        return RecommendedRemediationAction.fromValue(this.recommendedAction);
    }

    public final String recommendedActionAsString() {
        return this.recommendedAction;
    }

    public final String recommendedPolicy() {
        return this.recommendedPolicy;
    }

    public final String existingPolicyId() {
        return this.existingPolicyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingPolicyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnusedPermissionsRecommendedStep)) {
            return false;
        }
        UnusedPermissionsRecommendedStep other = (UnusedPermissionsRecommendedStep)obj;
        return Objects.equals(this.policyUpdatedAt(), other.policyUpdatedAt()) && Objects.equals(this.recommendedActionAsString(), other.recommendedActionAsString()) && Objects.equals(this.recommendedPolicy(), other.recommendedPolicy()) && Objects.equals(this.existingPolicyId(), other.existingPolicyId());
    }

    public final String toString() {
        return ToString.builder((String)"UnusedPermissionsRecommendedStep").add("PolicyUpdatedAt", (Object)this.policyUpdatedAt()).add("RecommendedAction", (Object)this.recommendedActionAsString()).add("RecommendedPolicy", (Object)this.recommendedPolicy()).add("ExistingPolicyId", (Object)this.existingPolicyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.policyUpdatedAt()));
            }
            case "recommendedAction": {
                return Optional.ofNullable(clazz.cast(this.recommendedActionAsString()));
            }
            case "recommendedPolicy": {
                return Optional.ofNullable(clazz.cast(this.recommendedPolicy()));
            }
            case "existingPolicyId": {
                return Optional.ofNullable(clazz.cast(this.existingPolicyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnusedPermissionsRecommendedStep, T> g) {
        return obj -> g.apply((UnusedPermissionsRecommendedStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant policyUpdatedAt;
        private String recommendedAction;
        private String recommendedPolicy;
        private String existingPolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UnusedPermissionsRecommendedStep model) {
            this.policyUpdatedAt(model.policyUpdatedAt);
            this.recommendedAction(model.recommendedAction);
            this.recommendedPolicy(model.recommendedPolicy);
            this.existingPolicyId(model.existingPolicyId);
        }

        public final Instant getPolicyUpdatedAt() {
            return this.policyUpdatedAt;
        }

        public final void setPolicyUpdatedAt(Instant policyUpdatedAt) {
            this.policyUpdatedAt = policyUpdatedAt;
        }

        @Override
        public final Builder policyUpdatedAt(Instant policyUpdatedAt) {
            this.policyUpdatedAt = policyUpdatedAt;
            return this;
        }

        public final String getRecommendedAction() {
            return this.recommendedAction;
        }

        public final void setRecommendedAction(String recommendedAction) {
            this.recommendedAction = recommendedAction;
        }

        @Override
        public final Builder recommendedAction(String recommendedAction) {
            this.recommendedAction = recommendedAction;
            return this;
        }

        @Override
        public final Builder recommendedAction(RecommendedRemediationAction recommendedAction) {
            this.recommendedAction(recommendedAction == null ? null : recommendedAction.toString());
            return this;
        }

        public final String getRecommendedPolicy() {
            return this.recommendedPolicy;
        }

        public final void setRecommendedPolicy(String recommendedPolicy) {
            this.recommendedPolicy = recommendedPolicy;
        }

        @Override
        public final Builder recommendedPolicy(String recommendedPolicy) {
            this.recommendedPolicy = recommendedPolicy;
            return this;
        }

        public final String getExistingPolicyId() {
            return this.existingPolicyId;
        }

        public final void setExistingPolicyId(String existingPolicyId) {
            this.existingPolicyId = existingPolicyId;
        }

        @Override
        public final Builder existingPolicyId(String existingPolicyId) {
            this.existingPolicyId = existingPolicyId;
            return this;
        }

        public UnusedPermissionsRecommendedStep build() {
            return new UnusedPermissionsRecommendedStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnusedPermissionsRecommendedStep> {
        public Builder policyUpdatedAt(Instant var1);

        public Builder recommendedAction(String var1);

        public Builder recommendedAction(RecommendedRemediationAction var1);

        public Builder recommendedPolicy(String var1);

        public Builder existingPolicyId(String var1);
    }
}

