/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingRecommendationRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingRecommendationResponse;
import software.amazon.awssdk.services.accessanalyzer.model.RecommendedStep;

public class GetFindingRecommendationIterable
implements SdkIterable<GetFindingRecommendationResponse> {
    private final AccessAnalyzerClient client;
    private final GetFindingRecommendationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFindingRecommendationIterable(AccessAnalyzerClient client, GetFindingRecommendationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetFindingRecommendationResponseFetcher();
    }

    public Iterator<GetFindingRecommendationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecommendedStep> recommendedSteps() {
        Function<GetFindingRecommendationResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendedSteps() != null) {
                return response.recommendedSteps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetFindingRecommendationResponseFetcher
    implements SyncPageFetcher<GetFindingRecommendationResponse> {
        private GetFindingRecommendationResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingRecommendationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFindingRecommendationResponse nextPage(GetFindingRecommendationResponse previousPage) {
            if (previousPage == null) {
                return GetFindingRecommendationIterable.this.client.getFindingRecommendation(GetFindingRecommendationIterable.this.firstRequest);
            }
            return GetFindingRecommendationIterable.this.client.getFindingRecommendation((GetFindingRecommendationRequest)((Object)GetFindingRecommendationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

