/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ToDeleteIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteImportDataRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, BatchDeleteImportDataRequest> {
    private static final SdkField<List<String>> IMPORT_TASK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("importTaskIds").getter(BatchDeleteImportDataRequest.getter(BatchDeleteImportDataRequest::importTaskIds)).setter(BatchDeleteImportDataRequest.setter(Builder::importTaskIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importTaskIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETE_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deleteHistory").getter(BatchDeleteImportDataRequest.getter(BatchDeleteImportDataRequest::deleteHistory)).setter(BatchDeleteImportDataRequest.setter(Builder::deleteHistory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteHistory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TASK_IDS_FIELD, DELETE_HISTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteImportDataRequest.memberNameToFieldInitializer();
    private final List<String> importTaskIds;
    private final Boolean deleteHistory;

    private BatchDeleteImportDataRequest(BuilderImpl builder) {
        super(builder);
        this.importTaskIds = builder.importTaskIds;
        this.deleteHistory = builder.deleteHistory;
    }

    public final boolean hasImportTaskIds() {
        return this.importTaskIds != null && !(this.importTaskIds instanceof SdkAutoConstructList);
    }

    public final List<String> importTaskIds() {
        return this.importTaskIds;
    }

    public final Boolean deleteHistory() {
        return this.deleteHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportTaskIds() ? this.importTaskIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteHistory());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImportDataRequest)) {
            return false;
        }
        BatchDeleteImportDataRequest other = (BatchDeleteImportDataRequest)((Object)obj);
        return this.hasImportTaskIds() == other.hasImportTaskIds() && Objects.equals(this.importTaskIds(), other.importTaskIds()) && Objects.equals(this.deleteHistory(), other.deleteHistory());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteImportDataRequest").add("ImportTaskIds", this.hasImportTaskIds() ? this.importTaskIds() : null).add("DeleteHistory", (Object)this.deleteHistory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importTaskIds": {
                return Optional.ofNullable(clazz.cast(this.importTaskIds()));
            }
            case "deleteHistory": {
                return Optional.ofNullable(clazz.cast(this.deleteHistory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("importTaskIds", IMPORT_TASK_IDS_FIELD);
        map.put("deleteHistory", DELETE_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteImportDataRequest, T> g) {
        return obj -> g.apply((BatchDeleteImportDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private List<String> importTaskIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean deleteHistory;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImportDataRequest model) {
            super(model);
            this.importTaskIds(model.importTaskIds);
            this.deleteHistory(model.deleteHistory);
        }

        public final Collection<String> getImportTaskIds() {
            if (this.importTaskIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.importTaskIds;
        }

        public final void setImportTaskIds(Collection<String> importTaskIds) {
            this.importTaskIds = ToDeleteIdentifierListCopier.copy(importTaskIds);
        }

        @Override
        public final Builder importTaskIds(Collection<String> importTaskIds) {
            this.importTaskIds = ToDeleteIdentifierListCopier.copy(importTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTaskIds(String ... importTaskIds) {
            this.importTaskIds(Arrays.asList(importTaskIds));
            return this;
        }

        public final Boolean getDeleteHistory() {
            return this.deleteHistory;
        }

        public final void setDeleteHistory(Boolean deleteHistory) {
            this.deleteHistory = deleteHistory;
        }

        @Override
        public final Builder deleteHistory(Boolean deleteHistory) {
            this.deleteHistory = deleteHistory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteImportDataRequest build() {
            return new BatchDeleteImportDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteImportDataRequest> {
        public Builder importTaskIds(Collection<String> var1);

        public Builder importTaskIds(String ... var1);

        public Builder deleteHistory(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

