/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationsignals.model.MetricDataQueriesCopier;
import software.amazon.awssdk.services.applicationsignals.model.MetricDataQuery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoredRequestCountMetricDataQueries
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoredRequestCountMetricDataQueries> {
    private static final SdkField<List<MetricDataQuery>> GOOD_COUNT_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GoodCountMetric").getter(MonitoredRequestCountMetricDataQueries.getter(MonitoredRequestCountMetricDataQueries::goodCountMetric)).setter(MonitoredRequestCountMetricDataQueries.setter(Builder::goodCountMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GoodCountMetric").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricDataQuery>> BAD_COUNT_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BadCountMetric").getter(MonitoredRequestCountMetricDataQueries.getter(MonitoredRequestCountMetricDataQueries::badCountMetric)).setter(MonitoredRequestCountMetricDataQueries.setter(Builder::badCountMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BadCountMetric").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GOOD_COUNT_METRIC_FIELD, BAD_COUNT_METRIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GoodCountMetric", GOOD_COUNT_METRIC_FIELD);
            this.put("BadCountMetric", BAD_COUNT_METRIC_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<MetricDataQuery> goodCountMetric;
    private final List<MetricDataQuery> badCountMetric;
    private final Type type;

    private MonitoredRequestCountMetricDataQueries(BuilderImpl builder) {
        this.goodCountMetric = builder.goodCountMetric;
        this.badCountMetric = builder.badCountMetric;
        this.type = builder.type;
    }

    public final boolean hasGoodCountMetric() {
        return this.goodCountMetric != null && !(this.goodCountMetric instanceof SdkAutoConstructList);
    }

    public final List<MetricDataQuery> goodCountMetric() {
        return this.goodCountMetric;
    }

    public final boolean hasBadCountMetric() {
        return this.badCountMetric != null && !(this.badCountMetric instanceof SdkAutoConstructList);
    }

    public final List<MetricDataQuery> badCountMetric() {
        return this.badCountMetric;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGoodCountMetric() ? this.goodCountMetric() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBadCountMetric() ? this.badCountMetric() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoredRequestCountMetricDataQueries)) {
            return false;
        }
        MonitoredRequestCountMetricDataQueries other = (MonitoredRequestCountMetricDataQueries)obj;
        return this.hasGoodCountMetric() == other.hasGoodCountMetric() && Objects.equals(this.goodCountMetric(), other.goodCountMetric()) && this.hasBadCountMetric() == other.hasBadCountMetric() && Objects.equals(this.badCountMetric(), other.badCountMetric());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoredRequestCountMetricDataQueries").add("GoodCountMetric", this.hasGoodCountMetric() ? this.goodCountMetric() : null).add("BadCountMetric", this.hasBadCountMetric() ? this.badCountMetric() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GoodCountMetric": {
                return Optional.ofNullable(clazz.cast(this.goodCountMetric()));
            }
            case "BadCountMetric": {
                return Optional.ofNullable(clazz.cast(this.badCountMetric()));
            }
        }
        return Optional.empty();
    }

    public static MonitoredRequestCountMetricDataQueries fromGoodCountMetric(List<MetricDataQuery> goodCountMetric) {
        return (MonitoredRequestCountMetricDataQueries)MonitoredRequestCountMetricDataQueries.builder().goodCountMetric(goodCountMetric).build();
    }

    public static MonitoredRequestCountMetricDataQueries fromBadCountMetric(List<MetricDataQuery> badCountMetric) {
        return (MonitoredRequestCountMetricDataQueries)MonitoredRequestCountMetricDataQueries.builder().badCountMetric(badCountMetric).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MonitoredRequestCountMetricDataQueries, T> g) {
        return obj -> g.apply((MonitoredRequestCountMetricDataQueries)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        GOOD_COUNT_METRIC,
        BAD_COUNT_METRIC,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<MetricDataQuery> goodCountMetric = DefaultSdkAutoConstructList.getInstance();
        private List<MetricDataQuery> badCountMetric = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoredRequestCountMetricDataQueries model) {
            this.goodCountMetric(model.goodCountMetric);
            this.badCountMetric(model.badCountMetric);
        }

        public final List<MetricDataQuery.Builder> getGoodCountMetric() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.goodCountMetric);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGoodCountMetric(Collection<MetricDataQuery.BuilderImpl> goodCountMetric) {
            List<MetricDataQuery> oldValue = this.goodCountMetric;
            this.goodCountMetric = MetricDataQueriesCopier.copyFromBuilder(goodCountMetric);
            this.handleUnionValueChange(Type.GOOD_COUNT_METRIC, oldValue, this.goodCountMetric);
        }

        @Override
        public final Builder goodCountMetric(Collection<MetricDataQuery> goodCountMetric) {
            List<MetricDataQuery> oldValue = this.goodCountMetric;
            this.goodCountMetric = MetricDataQueriesCopier.copy(goodCountMetric);
            this.handleUnionValueChange(Type.GOOD_COUNT_METRIC, oldValue, this.goodCountMetric);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder goodCountMetric(MetricDataQuery ... goodCountMetric) {
            this.goodCountMetric(Arrays.asList(goodCountMetric));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder goodCountMetric(Consumer<MetricDataQuery.Builder> ... goodCountMetric) {
            this.goodCountMetric(Stream.of(goodCountMetric).map(c -> (MetricDataQuery)((MetricDataQuery.Builder)MetricDataQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MetricDataQuery.Builder> getBadCountMetric() {
            List<MetricDataQuery.Builder> result = MetricDataQueriesCopier.copyToBuilder(this.badCountMetric);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBadCountMetric(Collection<MetricDataQuery.BuilderImpl> badCountMetric) {
            List<MetricDataQuery> oldValue = this.badCountMetric;
            this.badCountMetric = MetricDataQueriesCopier.copyFromBuilder(badCountMetric);
            this.handleUnionValueChange(Type.BAD_COUNT_METRIC, oldValue, this.badCountMetric);
        }

        @Override
        public final Builder badCountMetric(Collection<MetricDataQuery> badCountMetric) {
            List<MetricDataQuery> oldValue = this.badCountMetric;
            this.badCountMetric = MetricDataQueriesCopier.copy(badCountMetric);
            this.handleUnionValueChange(Type.BAD_COUNT_METRIC, oldValue, this.badCountMetric);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder badCountMetric(MetricDataQuery ... badCountMetric) {
            this.badCountMetric(Arrays.asList(badCountMetric));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder badCountMetric(Consumer<MetricDataQuery.Builder> ... badCountMetric) {
            this.badCountMetric(Stream.of(badCountMetric).map(c -> (MetricDataQuery)((MetricDataQuery.Builder)MetricDataQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MonitoredRequestCountMetricDataQueries build() {
            return new MonitoredRequestCountMetricDataQueries(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoredRequestCountMetricDataQueries> {
        public Builder goodCountMetric(Collection<MetricDataQuery> var1);

        public Builder goodCountMetric(MetricDataQuery ... var1);

        public Builder goodCountMetric(Consumer<MetricDataQuery.Builder> ... var1);

        public Builder badCountMetric(Collection<MetricDataQuery> var1);

        public Builder badCountMetric(MetricDataQuery ... var1);

        public Builder badCountMetric(Consumer<MetricDataQuery.Builder> ... var1);
    }
}

