/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceDependenciesResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceDependency;

public class ListServiceDependenciesIterable
implements SdkIterable<ListServiceDependenciesResponse> {
    private final ApplicationSignalsClient client;
    private final ListServiceDependenciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceDependenciesIterable(ApplicationSignalsClient client, ListServiceDependenciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceDependenciesResponseFetcher();
    }

    public Iterator<ListServiceDependenciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceDependency> serviceDependencies() {
        Function<ListServiceDependenciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceDependencies() != null) {
                return response.serviceDependencies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceDependenciesResponseFetcher
    implements SyncPageFetcher<ListServiceDependenciesResponse> {
        private ListServiceDependenciesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceDependenciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceDependenciesResponse nextPage(ListServiceDependenciesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceDependenciesIterable.this.client.listServiceDependencies(ListServiceDependenciesIterable.this.firstRequest);
            }
            return ListServiceDependenciesIterable.this.client.listServiceDependencies((ListServiceDependenciesRequest)((Object)ListServiceDependenciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

