/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationsignals.ApplicationSignalsAsyncClient;
import software.amazon.awssdk.services.applicationsignals.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesRequest;
import software.amazon.awssdk.services.applicationsignals.model.ListServiceLevelObjectivesResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveSummary;

public class ListServiceLevelObjectivesPublisher
implements SdkPublisher<ListServiceLevelObjectivesResponse> {
    private final ApplicationSignalsAsyncClient client;
    private final ListServiceLevelObjectivesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceLevelObjectivesPublisher(ApplicationSignalsAsyncClient client, ListServiceLevelObjectivesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceLevelObjectivesPublisher(ApplicationSignalsAsyncClient client, ListServiceLevelObjectivesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceLevelObjectivesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceLevelObjectivesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceLevelObjectiveSummary> sloSummaries() {
        Function<ListServiceLevelObjectivesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sloSummaries() != null) {
                return response.sloSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceLevelObjectivesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceLevelObjectivesResponseFetcher
    implements AsyncPageFetcher<ListServiceLevelObjectivesResponse> {
        private ListServiceLevelObjectivesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceLevelObjectivesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceLevelObjectivesResponse> nextPage(ListServiceLevelObjectivesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceLevelObjectivesPublisher.this.client.listServiceLevelObjectives(ListServiceLevelObjectivesPublisher.this.firstRequest);
            }
            return ListServiceLevelObjectivesPublisher.this.client.listServiceLevelObjectives((ListServiceLevelObjectivesRequest)((Object)ListServiceLevelObjectivesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

