/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmdataexports.model.BcmDataExportsResponse;
import software.amazon.awssdk.services.bcmdataexports.model.ExecutionReference;
import software.amazon.awssdk.services.bcmdataexports.model.ExecutionReferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExecutionsResponse
extends BcmDataExportsResponse
implements ToCopyableBuilder<Builder, ListExecutionsResponse> {
    private static final SdkField<List<ExecutionReference>> EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Executions").getter(ListExecutionsResponse.getter(ListExecutionsResponse::executions)).setter(ListExecutionsResponse.setter(Builder::executions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Executions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExecutionReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListExecutionsResponse.getter(ListExecutionsResponse::nextToken)).setter(ListExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExecutionsResponse.memberNameToFieldInitializer();
    private final List<ExecutionReference> executions;
    private final String nextToken;

    private ListExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.executions = builder.executions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExecutions() {
        return this.executions != null && !(this.executions instanceof SdkAutoConstructList);
    }

    public final List<ExecutionReference> executions() {
        return this.executions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutions() ? this.executions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutionsResponse)) {
            return false;
        }
        ListExecutionsResponse other = (ListExecutionsResponse)((Object)obj);
        return this.hasExecutions() == other.hasExecutions() && Objects.equals(this.executions(), other.executions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExecutionsResponse").add("Executions", this.hasExecutions() ? this.executions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Executions": {
                return Optional.ofNullable(clazz.cast(this.executions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Executions", EXECUTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExecutionsResponse, T> g) {
        return obj -> g.apply((ListExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmDataExportsResponse.BuilderImpl
    implements Builder {
        private List<ExecutionReference> executions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutionsResponse model) {
            super(model);
            this.executions(model.executions);
            this.nextToken(model.nextToken);
        }

        public final List<ExecutionReference.Builder> getExecutions() {
            List<ExecutionReference.Builder> result = ExecutionReferenceListCopier.copyToBuilder(this.executions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutions(Collection<ExecutionReference.BuilderImpl> executions) {
            this.executions = ExecutionReferenceListCopier.copyFromBuilder(executions);
        }

        @Override
        public final Builder executions(Collection<ExecutionReference> executions) {
            this.executions = ExecutionReferenceListCopier.copy(executions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executions(ExecutionReference ... executions) {
            this.executions(Arrays.asList(executions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executions(Consumer<ExecutionReference.Builder> ... executions) {
            this.executions(Stream.of(executions).map(c -> (ExecutionReference)((ExecutionReference.Builder)ExecutionReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExecutionsResponse build() {
            return new ListExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmDataExportsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExecutionsResponse> {
        public Builder executions(Collection<ExecutionReference> var1);

        public Builder executions(ExecutionReference ... var1);

        public Builder executions(Consumer<ExecutionReference.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

