/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.ListPromptsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListPromptsResponse;
import software.amazon.awssdk.services.bedrockagent.model.PromptSummary;

public class ListPromptsPublisher
implements SdkPublisher<ListPromptsResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListPromptsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPromptsPublisher(BedrockAgentAsyncClient client, ListPromptsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPromptsPublisher(BedrockAgentAsyncClient client, ListPromptsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPromptsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPromptsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PromptSummary> promptSummaries() {
        Function<ListPromptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.promptSummaries() != null) {
                return response.promptSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPromptsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPromptsResponseFetcher
    implements AsyncPageFetcher<ListPromptsResponse> {
        private ListPromptsResponseFetcher() {
        }

        public boolean hasNextPage(ListPromptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPromptsResponse> nextPage(ListPromptsResponse previousPage) {
            if (previousPage == null) {
                return ListPromptsPublisher.this.client.listPrompts(ListPromptsPublisher.this.firstRequest);
            }
            return ListPromptsPublisher.this.client.listPrompts((ListPromptsRequest)((Object)ListPromptsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

