/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.PineconeFieldMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PineconeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PineconeConfiguration> {
    private static final SdkField<String> CONNECTION_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionString").getter(PineconeConfiguration.getter(PineconeConfiguration::connectionString)).setter(PineconeConfiguration.setter(Builder::connectionString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionString").build()}).build();
    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialsSecretArn").getter(PineconeConfiguration.getter(PineconeConfiguration::credentialsSecretArn)).setter(PineconeConfiguration.setter(Builder::credentialsSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build()}).build();
    private static final SdkField<PineconeFieldMapping> FIELD_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fieldMapping").getter(PineconeConfiguration.getter(PineconeConfiguration::fieldMapping)).setter(PineconeConfiguration.setter(Builder::fieldMapping)).constructor(PineconeFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(PineconeConfiguration.getter(PineconeConfiguration::namespace)).setter(PineconeConfiguration.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_STRING_FIELD, CREDENTIALS_SECRET_ARN_FIELD, FIELD_MAPPING_FIELD, NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("connectionString", CONNECTION_STRING_FIELD);
            this.put("credentialsSecretArn", CREDENTIALS_SECRET_ARN_FIELD);
            this.put("fieldMapping", FIELD_MAPPING_FIELD);
            this.put("namespace", NAMESPACE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String connectionString;
    private final String credentialsSecretArn;
    private final PineconeFieldMapping fieldMapping;
    private final String namespace;

    private PineconeConfiguration(BuilderImpl builder) {
        this.connectionString = builder.connectionString;
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.fieldMapping = builder.fieldMapping;
        this.namespace = builder.namespace;
    }

    public final String connectionString() {
        return this.connectionString;
    }

    public final String credentialsSecretArn() {
        return this.credentialsSecretArn;
    }

    public final PineconeFieldMapping fieldMapping() {
        return this.fieldMapping;
    }

    public final String namespace() {
        return this.namespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PineconeConfiguration)) {
            return false;
        }
        PineconeConfiguration other = (PineconeConfiguration)obj;
        return Objects.equals(this.connectionString(), other.connectionString()) && Objects.equals(this.credentialsSecretArn(), other.credentialsSecretArn()) && Objects.equals(this.fieldMapping(), other.fieldMapping()) && Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"PineconeConfiguration").add("ConnectionString", (Object)this.connectionString()).add("CredentialsSecretArn", (Object)this.credentialsSecretArn()).add("FieldMapping", (Object)this.fieldMapping()).add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionString": {
                return Optional.ofNullable(clazz.cast(this.connectionString()));
            }
            case "credentialsSecretArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsSecretArn()));
            }
            case "fieldMapping": {
                return Optional.ofNullable(clazz.cast(this.fieldMapping()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PineconeConfiguration, T> g) {
        return obj -> g.apply((PineconeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionString;
        private String credentialsSecretArn;
        private PineconeFieldMapping fieldMapping;
        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(PineconeConfiguration model) {
            this.connectionString(model.connectionString);
            this.credentialsSecretArn(model.credentialsSecretArn);
            this.fieldMapping(model.fieldMapping);
            this.namespace(model.namespace);
        }

        public final String getConnectionString() {
            return this.connectionString;
        }

        public final void setConnectionString(String connectionString) {
            this.connectionString = connectionString;
        }

        @Override
        public final Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public final String getCredentialsSecretArn() {
            return this.credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final PineconeFieldMapping.Builder getFieldMapping() {
            return this.fieldMapping != null ? this.fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(PineconeFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(PineconeFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PineconeConfiguration build() {
            return new PineconeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PineconeConfiguration> {
        public Builder connectionString(String var1);

        public Builder credentialsSecretArn(String var1);

        public Builder fieldMapping(PineconeFieldMapping var1);

        default public Builder fieldMapping(Consumer<PineconeFieldMapping.Builder> fieldMapping) {
            return this.fieldMapping((PineconeFieldMapping)((PineconeFieldMapping.Builder)PineconeFieldMapping.builder().applyMutation(fieldMapping)).build());
        }

        public Builder namespace(String var1);
    }
}

