/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponseElement;

public class ListResourcesAssociatedToCustomLineItemIterable
implements SdkIterable<ListResourcesAssociatedToCustomLineItemResponse> {
    private final BillingconductorClient client;
    private final ListResourcesAssociatedToCustomLineItemRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourcesAssociatedToCustomLineItemIterable(BillingconductorClient client, ListResourcesAssociatedToCustomLineItemRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourcesAssociatedToCustomLineItemResponseFetcher();
    }

    public Iterator<ListResourcesAssociatedToCustomLineItemResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListResourcesAssociatedToCustomLineItemResponseElement> associatedResources() {
        Function<ListResourcesAssociatedToCustomLineItemResponse, Iterator> getIterator = response -> {
            if (response != null && response.associatedResources() != null) {
                return response.associatedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourcesAssociatedToCustomLineItemResponseFetcher
    implements SyncPageFetcher<ListResourcesAssociatedToCustomLineItemResponse> {
        private ListResourcesAssociatedToCustomLineItemResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcesAssociatedToCustomLineItemResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourcesAssociatedToCustomLineItemResponse nextPage(ListResourcesAssociatedToCustomLineItemResponse previousPage) {
            if (previousPage == null) {
                return ListResourcesAssociatedToCustomLineItemIterable.this.client.listResourcesAssociatedToCustomLineItem(ListResourcesAssociatedToCustomLineItemIterable.this.firstRequest);
            }
            return ListResourcesAssociatedToCustomLineItemIterable.this.client.listResourcesAssociatedToCustomLineItem((ListResourcesAssociatedToCustomLineItemRequest)((Object)ListResourcesAssociatedToCustomLineItemIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

