/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MatchOption {
    NOT_EQUAL("NOT_EQUAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MatchOption> VALUE_MAP;
    private final String value;

    private MatchOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MatchOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MatchOption> knownValues() {
        EnumSet<MatchOption> knownValues = EnumSet.allOf(MatchOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MatchOption.class, MatchOption::toString);
    }
}

