/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesError;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesErrorsListCopier;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.RepositoryMetadata;
import software.amazon.awssdk.services.codecommit.model.RepositoryMetadataListCopier;
import software.amazon.awssdk.services.codecommit.model.RepositoryNotFoundListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetRepositoriesResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, BatchGetRepositoriesResponse> {
    private static final SdkField<List<RepositoryMetadata>> REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositories").getter(BatchGetRepositoriesResponse.getter(BatchGetRepositoriesResponse::repositories)).setter(BatchGetRepositoriesResponse.setter(Builder::repositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REPOSITORIES_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("repositoriesNotFound").getter(BatchGetRepositoriesResponse.getter(BatchGetRepositoriesResponse::repositoriesNotFound)).setter(BatchGetRepositoriesResponse.setter(Builder::repositoriesNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoriesNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetRepositoriesError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetRepositoriesResponse.getter(BatchGetRepositoriesResponse::errors)).setter(BatchGetRepositoriesResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetRepositoriesError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORIES_FIELD, REPOSITORIES_NOT_FOUND_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("repositories", REPOSITORIES_FIELD);
            this.put("repositoriesNotFound", REPOSITORIES_NOT_FOUND_FIELD);
            this.put("errors", ERRORS_FIELD);
        }
    });
    private final List<RepositoryMetadata> repositories;
    private final List<String> repositoriesNotFound;
    private final List<BatchGetRepositoriesError> errors;

    private BatchGetRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.repositories = builder.repositories;
        this.repositoriesNotFound = builder.repositoriesNotFound;
        this.errors = builder.errors;
    }

    public final boolean hasRepositories() {
        return this.repositories != null && !(this.repositories instanceof SdkAutoConstructList);
    }

    public final List<RepositoryMetadata> repositories() {
        return this.repositories;
    }

    public final boolean hasRepositoriesNotFound() {
        return this.repositoriesNotFound != null && !(this.repositoriesNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> repositoriesNotFound() {
        return this.repositoriesNotFound;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetRepositoriesError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositories() ? this.repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositoriesNotFound() ? this.repositoriesNotFound() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRepositoriesResponse)) {
            return false;
        }
        BatchGetRepositoriesResponse other = (BatchGetRepositoriesResponse)((Object)obj);
        return this.hasRepositories() == other.hasRepositories() && Objects.equals(this.repositories(), other.repositories()) && this.hasRepositoriesNotFound() == other.hasRepositoriesNotFound() && Objects.equals(this.repositoriesNotFound(), other.repositoriesNotFound()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetRepositoriesResponse").add("Repositories", this.hasRepositories() ? this.repositories() : null).add("RepositoriesNotFound", this.hasRepositoriesNotFound() ? this.repositoriesNotFound() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositories": {
                return Optional.ofNullable(clazz.cast(this.repositories()));
            }
            case "repositoriesNotFound": {
                return Optional.ofNullable(clazz.cast(this.repositoriesNotFound()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRepositoriesResponse, T> g) {
        return obj -> g.apply((BatchGetRepositoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<RepositoryMetadata> repositories = DefaultSdkAutoConstructList.getInstance();
        private List<String> repositoriesNotFound = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetRepositoriesError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRepositoriesResponse model) {
            super(model);
            this.repositories(model.repositories);
            this.repositoriesNotFound(model.repositoriesNotFound);
            this.errors(model.errors);
        }

        public final List<RepositoryMetadata.Builder> getRepositories() {
            List<RepositoryMetadata.Builder> result = RepositoryMetadataListCopier.copyToBuilder(this.repositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositories(Collection<RepositoryMetadata.BuilderImpl> repositories) {
            this.repositories = RepositoryMetadataListCopier.copyFromBuilder(repositories);
        }

        @Override
        public final Builder repositories(Collection<RepositoryMetadata> repositories) {
            this.repositories = RepositoryMetadataListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(RepositoryMetadata ... repositories) {
            this.repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<RepositoryMetadata.Builder> ... repositories) {
            this.repositories(Stream.of(repositories).map(c -> (RepositoryMetadata)((RepositoryMetadata.Builder)RepositoryMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRepositoriesNotFound() {
            if (this.repositoriesNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.repositoriesNotFound;
        }

        public final void setRepositoriesNotFound(Collection<String> repositoriesNotFound) {
            this.repositoriesNotFound = RepositoryNotFoundListCopier.copy(repositoriesNotFound);
        }

        @Override
        public final Builder repositoriesNotFound(Collection<String> repositoriesNotFound) {
            this.repositoriesNotFound = RepositoryNotFoundListCopier.copy(repositoriesNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoriesNotFound(String ... repositoriesNotFound) {
            this.repositoriesNotFound(Arrays.asList(repositoriesNotFound));
            return this;
        }

        public final List<BatchGetRepositoriesError.Builder> getErrors() {
            List<BatchGetRepositoriesError.Builder> result = BatchGetRepositoriesErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetRepositoriesError.BuilderImpl> errors) {
            this.errors = BatchGetRepositoriesErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetRepositoriesError> errors) {
            this.errors = BatchGetRepositoriesErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetRepositoriesError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetRepositoriesError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetRepositoriesError)((BatchGetRepositoriesError.Builder)BatchGetRepositoriesError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetRepositoriesResponse build() {
            return new BatchGetRepositoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetRepositoriesResponse> {
        public Builder repositories(Collection<RepositoryMetadata> var1);

        public Builder repositories(RepositoryMetadata ... var1);

        public Builder repositories(Consumer<RepositoryMetadata.Builder> ... var1);

        public Builder repositoriesNotFound(Collection<String> var1);

        public Builder repositoriesNotFound(String ... var1);

        public Builder errors(Collection<BatchGetRepositoriesError> var1);

        public Builder errors(BatchGetRepositoriesError ... var1);

        public Builder errors(Consumer<BatchGetRepositoriesError.Builder> ... var1);
    }
}

