/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.RuleConfigurationPropertyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleConfigurationProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleConfigurationProperty> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RuleConfigurationProperty.getter(RuleConfigurationProperty::name)).setter(RuleConfigurationProperty.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("required").getter(RuleConfigurationProperty.getter(RuleConfigurationProperty::required)).setter(RuleConfigurationProperty.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()}).build();
    private static final SdkField<Boolean> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("key").getter(RuleConfigurationProperty.getter(RuleConfigurationProperty::key)).setter(RuleConfigurationProperty.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<Boolean> SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("secret").getter(RuleConfigurationProperty.getter(RuleConfigurationProperty::secret)).setter(RuleConfigurationProperty.setter(Builder::secret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secret").build()}).build();
    private static final SdkField<Boolean> QUERYABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("queryable").getter(RuleConfigurationProperty.getter(RuleConfigurationProperty::queryable)).setter(RuleConfigurationProperty.setter(Builder::queryable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryable").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(RuleConfigurationProperty.getter(RuleConfigurationProperty::description)).setter(RuleConfigurationProperty.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RuleConfigurationProperty.getter(RuleConfigurationProperty::typeAsString)).setter(RuleConfigurationProperty.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REQUIRED_FIELD, KEY_FIELD, SECRET_FIELD, QUERYABLE_FIELD, DESCRIPTION_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("required", REQUIRED_FIELD);
            this.put("key", KEY_FIELD);
            this.put("secret", SECRET_FIELD);
            this.put("queryable", QUERYABLE_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Boolean required;
    private final Boolean key;
    private final Boolean secret;
    private final Boolean queryable;
    private final String description;
    private final String type;

    private RuleConfigurationProperty(BuilderImpl builder) {
        this.name = builder.name;
        this.required = builder.required;
        this.key = builder.key;
        this.secret = builder.secret;
        this.queryable = builder.queryable;
        this.description = builder.description;
        this.type = builder.type;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean required() {
        return this.required;
    }

    public final Boolean key() {
        return this.key;
    }

    public final Boolean secret() {
        return this.secret;
    }

    public final Boolean queryable() {
        return this.queryable;
    }

    public final String description() {
        return this.description;
    }

    public final RuleConfigurationPropertyType type() {
        return RuleConfigurationPropertyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.required());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.secret());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryable());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleConfigurationProperty)) {
            return false;
        }
        RuleConfigurationProperty other = (RuleConfigurationProperty)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.required(), other.required()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.secret(), other.secret()) && Objects.equals(this.queryable(), other.queryable()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RuleConfigurationProperty").add("Name", (Object)this.name()).add("Required", (Object)this.required()).add("Key", (Object)this.key()).add("Secret", (Object)this.secret()).add("Queryable", (Object)this.queryable()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "secret": {
                return Optional.ofNullable(clazz.cast(this.secret()));
            }
            case "queryable": {
                return Optional.ofNullable(clazz.cast(this.queryable()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RuleConfigurationProperty, T> g) {
        return obj -> g.apply((RuleConfigurationProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean required;
        private Boolean key;
        private Boolean secret;
        private Boolean queryable;
        private String description;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleConfigurationProperty model) {
            this.name(model.name);
            this.required(model.required);
            this.key(model.key);
            this.secret(model.secret);
            this.queryable(model.queryable);
            this.description(model.description);
            this.type(model.type);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getRequired() {
            return this.required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final Boolean getKey() {
            return this.key;
        }

        public final void setKey(Boolean key) {
            this.key = key;
        }

        @Override
        public final Builder key(Boolean key) {
            this.key = key;
            return this;
        }

        public final Boolean getSecret() {
            return this.secret;
        }

        public final void setSecret(Boolean secret) {
            this.secret = secret;
        }

        @Override
        public final Builder secret(Boolean secret) {
            this.secret = secret;
            return this;
        }

        public final Boolean getQueryable() {
            return this.queryable;
        }

        public final void setQueryable(Boolean queryable) {
            this.queryable = queryable;
        }

        @Override
        public final Builder queryable(Boolean queryable) {
            this.queryable = queryable;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RuleConfigurationPropertyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RuleConfigurationProperty build() {
            return new RuleConfigurationProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleConfigurationProperty> {
        public Builder name(String var1);

        public Builder required(Boolean var1);

        public Builder key(Boolean var1);

        public Builder secret(Boolean var1);

        public Builder queryable(Boolean var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(RuleConfigurationPropertyType var1);
    }
}

