/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AsgType {
    SINGLE_INSTANCE_TYPE("SingleInstanceType"),
    MIXED_INSTANCE_TYPES("MixedInstanceTypes"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AsgType> VALUE_MAP;
    private final String value;

    private AsgType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AsgType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AsgType> knownValues() {
        EnumSet<AsgType> knownValues = EnumSet.allOf(AsgType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AsgType.class, AsgType::toString);
    }
}

