/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceMetricName;
import software.amazon.awssdk.services.computeoptimizer.model.MetricValuesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.TimestampsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ECSServiceProjectedMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ECSServiceProjectedMetric> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ECSServiceProjectedMetric.getter(ECSServiceProjectedMetric::nameAsString)).setter(ECSServiceProjectedMetric.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<Instant>> TIMESTAMPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("timestamps").getter(ECSServiceProjectedMetric.getter(ECSServiceProjectedMetric::timestamps)).setter(ECSServiceProjectedMetric.setter(Builder::timestamps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> UPPER_BOUND_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("upperBoundValues").getter(ECSServiceProjectedMetric.getter(ECSServiceProjectedMetric::upperBoundValues)).setter(ECSServiceProjectedMetric.setter(Builder::upperBoundValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upperBoundValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> LOWER_BOUND_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lowerBoundValues").getter(ECSServiceProjectedMetric.getter(ECSServiceProjectedMetric::lowerBoundValues)).setter(ECSServiceProjectedMetric.setter(Builder::lowerBoundValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lowerBoundValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TIMESTAMPS_FIELD, UPPER_BOUND_VALUES_FIELD, LOWER_BOUND_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ECSServiceProjectedMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<Instant> timestamps;
    private final List<Double> upperBoundValues;
    private final List<Double> lowerBoundValues;

    private ECSServiceProjectedMetric(BuilderImpl builder) {
        this.name = builder.name;
        this.timestamps = builder.timestamps;
        this.upperBoundValues = builder.upperBoundValues;
        this.lowerBoundValues = builder.lowerBoundValues;
    }

    public final ECSServiceMetricName name() {
        return ECSServiceMetricName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final boolean hasTimestamps() {
        return this.timestamps != null && !(this.timestamps instanceof SdkAutoConstructList);
    }

    public final List<Instant> timestamps() {
        return this.timestamps;
    }

    public final boolean hasUpperBoundValues() {
        return this.upperBoundValues != null && !(this.upperBoundValues instanceof SdkAutoConstructList);
    }

    public final List<Double> upperBoundValues() {
        return this.upperBoundValues;
    }

    public final boolean hasLowerBoundValues() {
        return this.lowerBoundValues != null && !(this.lowerBoundValues instanceof SdkAutoConstructList);
    }

    public final List<Double> lowerBoundValues() {
        return this.lowerBoundValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimestamps() ? this.timestamps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpperBoundValues() ? this.upperBoundValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLowerBoundValues() ? this.lowerBoundValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceProjectedMetric)) {
            return false;
        }
        ECSServiceProjectedMetric other = (ECSServiceProjectedMetric)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && this.hasTimestamps() == other.hasTimestamps() && Objects.equals(this.timestamps(), other.timestamps()) && this.hasUpperBoundValues() == other.hasUpperBoundValues() && Objects.equals(this.upperBoundValues(), other.upperBoundValues()) && this.hasLowerBoundValues() == other.hasLowerBoundValues() && Objects.equals(this.lowerBoundValues(), other.lowerBoundValues());
    }

    public final String toString() {
        return ToString.builder((String)"ECSServiceProjectedMetric").add("Name", (Object)this.nameAsString()).add("Timestamps", this.hasTimestamps() ? this.timestamps() : null).add("UpperBoundValues", this.hasUpperBoundValues() ? this.upperBoundValues() : null).add("LowerBoundValues", this.hasLowerBoundValues() ? this.lowerBoundValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "timestamps": {
                return Optional.ofNullable(clazz.cast(this.timestamps()));
            }
            case "upperBoundValues": {
                return Optional.ofNullable(clazz.cast(this.upperBoundValues()));
            }
            case "lowerBoundValues": {
                return Optional.ofNullable(clazz.cast(this.lowerBoundValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("timestamps", TIMESTAMPS_FIELD);
        map.put("upperBoundValues", UPPER_BOUND_VALUES_FIELD);
        map.put("lowerBoundValues", LOWER_BOUND_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ECSServiceProjectedMetric, T> g) {
        return obj -> g.apply((ECSServiceProjectedMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<Instant> timestamps = DefaultSdkAutoConstructList.getInstance();
        private List<Double> upperBoundValues = DefaultSdkAutoConstructList.getInstance();
        private List<Double> lowerBoundValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ECSServiceProjectedMetric model) {
            this.name(model.name);
            this.timestamps(model.timestamps);
            this.upperBoundValues(model.upperBoundValues);
            this.lowerBoundValues(model.lowerBoundValues);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ECSServiceMetricName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Collection<Instant> getTimestamps() {
            if (this.timestamps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.timestamps;
        }

        public final void setTimestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampsCopier.copy(timestamps);
        }

        @Override
        public final Builder timestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampsCopier.copy(timestamps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(Instant ... timestamps) {
            this.timestamps(Arrays.asList(timestamps));
            return this;
        }

        public final Collection<Double> getUpperBoundValues() {
            if (this.upperBoundValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.upperBoundValues;
        }

        public final void setUpperBoundValues(Collection<Double> upperBoundValues) {
            this.upperBoundValues = MetricValuesCopier.copy(upperBoundValues);
        }

        @Override
        public final Builder upperBoundValues(Collection<Double> upperBoundValues) {
            this.upperBoundValues = MetricValuesCopier.copy(upperBoundValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upperBoundValues(Double ... upperBoundValues) {
            this.upperBoundValues(Arrays.asList(upperBoundValues));
            return this;
        }

        public final Collection<Double> getLowerBoundValues() {
            if (this.lowerBoundValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lowerBoundValues;
        }

        public final void setLowerBoundValues(Collection<Double> lowerBoundValues) {
            this.lowerBoundValues = MetricValuesCopier.copy(lowerBoundValues);
        }

        @Override
        public final Builder lowerBoundValues(Collection<Double> lowerBoundValues) {
            this.lowerBoundValues = MetricValuesCopier.copy(lowerBoundValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowerBoundValues(Double ... lowerBoundValues) {
            this.lowerBoundValues(Arrays.asList(lowerBoundValues));
            return this;
        }

        public ECSServiceProjectedMetric build() {
            return new ECSServiceProjectedMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ECSServiceProjectedMetric> {
        public Builder name(String var1);

        public Builder name(ECSServiceMetricName var1);

        public Builder timestamps(Collection<Instant> var1);

        public Builder timestamps(Instant ... var1);

        public Builder upperBoundValues(Collection<Double> var1);

        public Builder upperBoundValues(Double ... var1);

        public Builder lowerBoundValues(Collection<Double> var1);

        public Builder lowerBoundValues(Double ... var1);
    }
}

