/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizer.model.CustomizableMetricName;
import software.amazon.awssdk.services.computeoptimizer.model.CustomizableMetricParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UtilizationPreference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UtilizationPreference> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(UtilizationPreference.getter(UtilizationPreference::metricNameAsString)).setter(UtilizationPreference.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<CustomizableMetricParameters> METRIC_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metricParameters").getter(UtilizationPreference.getter(UtilizationPreference::metricParameters)).setter(UtilizationPreference.setter(Builder::metricParameters)).constructor(CustomizableMetricParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, METRIC_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UtilizationPreference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final CustomizableMetricParameters metricParameters;

    private UtilizationPreference(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.metricParameters = builder.metricParameters;
    }

    public final CustomizableMetricName metricName() {
        return CustomizableMetricName.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final CustomizableMetricParameters metricParameters() {
        return this.metricParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtilizationPreference)) {
            return false;
        }
        UtilizationPreference other = (UtilizationPreference)obj;
        return Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.metricParameters(), other.metricParameters());
    }

    public final String toString() {
        return ToString.builder((String)"UtilizationPreference").add("MetricName", (Object)this.metricNameAsString()).add("MetricParameters", (Object)this.metricParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "metricParameters": {
                return Optional.ofNullable(clazz.cast(this.metricParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("metricParameters", METRIC_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UtilizationPreference, T> g) {
        return obj -> g.apply((UtilizationPreference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private CustomizableMetricParameters metricParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(UtilizationPreference model) {
            this.metricName(model.metricName);
            this.metricParameters(model.metricParameters);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(CustomizableMetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final CustomizableMetricParameters.Builder getMetricParameters() {
            return this.metricParameters != null ? this.metricParameters.toBuilder() : null;
        }

        public final void setMetricParameters(CustomizableMetricParameters.BuilderImpl metricParameters) {
            this.metricParameters = metricParameters != null ? metricParameters.build() : null;
        }

        @Override
        public final Builder metricParameters(CustomizableMetricParameters metricParameters) {
            this.metricParameters = metricParameters;
            return this;
        }

        public UtilizationPreference build() {
            return new UtilizationPreference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UtilizationPreference> {
        public Builder metricName(String var1);

        public Builder metricName(CustomizableMetricName var1);

        public Builder metricParameters(CustomizableMetricParameters var1);

        default public Builder metricParameters(Consumer<CustomizableMetricParameters.Builder> metricParameters) {
            return this.metricParameters((CustomizableMetricParameters)((CustomizableMetricParameters.Builder)CustomizableMetricParameters.builder().applyMutation(metricParameters)).build());
        }
    }
}

