/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineBaselineIdentifiersCopier;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineTargetIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnabledBaselineFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnabledBaselineFilter> {
    private static final SdkField<List<String>> BASELINE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("baselineIdentifiers").getter(EnabledBaselineFilter.getter(EnabledBaselineFilter::baselineIdentifiers)).setter(EnabledBaselineFilter.setter(Builder::baselineIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetIdentifiers").getter(EnabledBaselineFilter.getter(EnabledBaselineFilter::targetIdentifiers)).setter(EnabledBaselineFilter.setter(Builder::targetIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_IDENTIFIERS_FIELD, TARGET_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("baselineIdentifiers", BASELINE_IDENTIFIERS_FIELD);
            this.put("targetIdentifiers", TARGET_IDENTIFIERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> baselineIdentifiers;
    private final List<String> targetIdentifiers;

    private EnabledBaselineFilter(BuilderImpl builder) {
        this.baselineIdentifiers = builder.baselineIdentifiers;
        this.targetIdentifiers = builder.targetIdentifiers;
    }

    public final boolean hasBaselineIdentifiers() {
        return this.baselineIdentifiers != null && !(this.baselineIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> baselineIdentifiers() {
        return this.baselineIdentifiers;
    }

    public final boolean hasTargetIdentifiers() {
        return this.targetIdentifiers != null && !(this.targetIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> targetIdentifiers() {
        return this.targetIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBaselineIdentifiers() ? this.baselineIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetIdentifiers() ? this.targetIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledBaselineFilter)) {
            return false;
        }
        EnabledBaselineFilter other = (EnabledBaselineFilter)obj;
        return this.hasBaselineIdentifiers() == other.hasBaselineIdentifiers() && Objects.equals(this.baselineIdentifiers(), other.baselineIdentifiers()) && this.hasTargetIdentifiers() == other.hasTargetIdentifiers() && Objects.equals(this.targetIdentifiers(), other.targetIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"EnabledBaselineFilter").add("BaselineIdentifiers", this.hasBaselineIdentifiers() ? this.baselineIdentifiers() : null).add("TargetIdentifiers", this.hasTargetIdentifiers() ? this.targetIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baselineIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.baselineIdentifiers()));
            }
            case "targetIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.targetIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnabledBaselineFilter, T> g) {
        return obj -> g.apply((EnabledBaselineFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> baselineIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledBaselineFilter model) {
            this.baselineIdentifiers(model.baselineIdentifiers);
            this.targetIdentifiers(model.targetIdentifiers);
        }

        public final Collection<String> getBaselineIdentifiers() {
            if (this.baselineIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.baselineIdentifiers;
        }

        public final void setBaselineIdentifiers(Collection<String> baselineIdentifiers) {
            this.baselineIdentifiers = EnabledBaselineBaselineIdentifiersCopier.copy(baselineIdentifiers);
        }

        @Override
        public final Builder baselineIdentifiers(Collection<String> baselineIdentifiers) {
            this.baselineIdentifiers = EnabledBaselineBaselineIdentifiersCopier.copy(baselineIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentifiers(String ... baselineIdentifiers) {
            this.baselineIdentifiers(Arrays.asList(baselineIdentifiers));
            return this;
        }

        public final Collection<String> getTargetIdentifiers() {
            if (this.targetIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetIdentifiers;
        }

        public final void setTargetIdentifiers(Collection<String> targetIdentifiers) {
            this.targetIdentifiers = EnabledBaselineTargetIdentifiersCopier.copy(targetIdentifiers);
        }

        @Override
        public final Builder targetIdentifiers(Collection<String> targetIdentifiers) {
            this.targetIdentifiers = EnabledBaselineTargetIdentifiersCopier.copy(targetIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIdentifiers(String ... targetIdentifiers) {
            this.targetIdentifiers(Arrays.asList(targetIdentifiers));
            return this;
        }

        public EnabledBaselineFilter build() {
            return new EnabledBaselineFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnabledBaselineFilter> {
        public Builder baselineIdentifiers(Collection<String> var1);

        public Builder baselineIdentifiers(String ... var1);

        public Builder targetIdentifiers(Collection<String> var1);

        public Builder targetIdentifiers(String ... var1);
    }
}

