/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.ReadLimitInfo;
import software.amazon.awssdk.RequestClientOptions;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.StaticCredentialsProvider;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.metrics.RequestMetricCollector;

@NotThreadSafe
public abstract class AmazonWebServiceRequest
implements Cloneable,
ReadLimitInfo {
    public static final AmazonWebServiceRequest NOOP = new AmazonWebServiceRequest(){};
    private final RequestClientOptions requestClientOptions = new RequestClientOptions();
    private ProgressListener progressListener = ProgressListener.NOOP;
    private RequestMetricCollector requestMetricCollector;
    private AwsCredentialsProvider credentialsProvider;
    private Map<String, String> customRequestHeaders;
    private Map<String, List<String>> customQueryParameters;
    private AmazonWebServiceRequest cloneSource;
    private Integer sdkClientExecutionTimeout = null;

    @Deprecated
    public void setRequestCredentials(AwsCredentials credentials) {
        this.credentialsProvider = credentials == null ? null : new StaticCredentialsProvider(credentials);
    }

    public AwsCredentialsProvider getRequestCredentialsProvider() {
        return this.credentialsProvider;
    }

    @ReviewBeforeRelease(value="This has been broken by the client/interface refactoring. Figure out how to fix it if we are keeping it")
    public void setRequestCredentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public RequestClientOptions getRequestClientOptions() {
        return this.requestClientOptions;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public void setRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.requestMetricCollector = requestMetricCollector;
    }

    public <T extends AmazonWebServiceRequest> T withRequestMetricCollector(RequestMetricCollector metricCollector) {
        this.setRequestMetricCollector(metricCollector);
        AmazonWebServiceRequest t = this;
        return (T)t;
    }

    public ProgressListener getGeneralProgressListener() {
        return this.progressListener;
    }

    public void setGeneralProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener == null ? ProgressListener.NOOP : progressListener;
    }

    public <T extends AmazonWebServiceRequest> T withGeneralProgressListener(ProgressListener progressListener) {
        this.setGeneralProgressListener(progressListener);
        AmazonWebServiceRequest t = this;
        return (T)t;
    }

    public Map<String, String> getCustomRequestHeaders() {
        if (this.customRequestHeaders == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customRequestHeaders);
    }

    public String putCustomRequestHeader(String name, String value) {
        if (this.customRequestHeaders == null) {
            this.customRequestHeaders = new HashMap<String, String>();
        }
        return this.customRequestHeaders.put(name, value);
    }

    public Map<String, List<String>> getCustomQueryParameters() {
        if (this.customQueryParameters == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customQueryParameters);
    }

    public void putCustomQueryParameter(String name, String value) {
        List<String> paramList;
        if (this.customQueryParameters == null) {
            this.customQueryParameters = new HashMap<String, List<String>>();
        }
        if ((paramList = this.customQueryParameters.get(name)) == null) {
            paramList = new LinkedList<String>();
            this.customQueryParameters.put(name, paramList);
        }
        paramList.add(value);
    }

    @Override
    public final int getReadLimit() {
        return this.requestClientOptions.getReadLimit();
    }

    protected final <T extends AmazonWebServiceRequest> T copyBaseTo(T target) {
        if (this.customRequestHeaders != null) {
            for (Map.Entry<String, Object> entry : this.customRequestHeaders.entrySet()) {
                target.putCustomRequestHeader(entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.customQueryParameters != null) {
            for (Map.Entry<String, Object> entry : this.customQueryParameters.entrySet()) {
                if (entry.getValue() == null) continue;
                for (String value : (List)entry.getValue()) {
                    target.putCustomQueryParameter(entry.getKey(), value);
                }
            }
        }
        target.setRequestCredentialsProvider(this.credentialsProvider);
        target.setGeneralProgressListener(this.progressListener);
        target.setRequestMetricCollector(this.requestMetricCollector);
        this.requestClientOptions.copyTo(target.getRequestClientOptions());
        return target;
    }

    public AmazonWebServiceRequest getCloneSource() {
        return this.cloneSource;
    }

    private void setCloneSource(AmazonWebServiceRequest cloneSource) {
        this.cloneSource = cloneSource;
    }

    public AmazonWebServiceRequest getCloneRoot() {
        AmazonWebServiceRequest cloneRoot = this.cloneSource;
        if (cloneRoot != null) {
            while (cloneRoot.getCloneSource() != null) {
                cloneRoot = cloneRoot.getCloneSource();
            }
        }
        return cloneRoot;
    }

    public Integer getSdkClientExecutionTimeout() {
        return this.sdkClientExecutionTimeout;
    }

    public void setSdkClientExecutionTimeout(int sdkClientExecutionTimeout) {
        this.sdkClientExecutionTimeout = sdkClientExecutionTimeout;
    }

    public <T extends AmazonWebServiceRequest> T withSdkClientExecutionTimeout(int sdkClientExecutionTimeout) {
        this.setSdkClientExecutionTimeout(sdkClientExecutionTimeout);
        AmazonWebServiceRequest t = this;
        return (T)t;
    }

    public AmazonWebServiceRequest clone() {
        try {
            AmazonWebServiceRequest cloned = (AmazonWebServiceRequest)super.clone();
            cloned.setCloneSource(this);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

