/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk;

import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.utils.SystemSetting;

@ReviewBeforeRelease(value="Do we need all of these, or can they be controlled in the client configuration?")
public enum AwsSystemSetting implements SystemSetting
{
    AWS_ACCESS_KEY_ID("aws.accessKeyId", null),
    AWS_SECRET_ACCESS_KEY("aws.secretAccessKey", null),
    AWS_SESSION_TOKEN("aws.sessionToken", null),
    AWS_REGION("aws.region", null),
    AWS_CONFIG_FILE("aws.configFile", null),
    AWS_DEFAULT_PROFILE("aws.defaultProfile", "default"),
    AWS_IN_REGION_OPTIMIZATION_ENABLED("aws.inRegionOptimizationEnabled", "false"),
    AWS_EXECUTION_ENV("aws.executionEnvironment", null),
    AWS_EC2_METADATA_SERVICE_ENDPOINT("aws.ec2MetadataServiceEndpoint", "http://169.254.169.254"),
    AWS_CONTAINER_SERVICE_ENDPOINT("aws.containerServiceEndpoint", "http://169.254.170.2"),
    AWS_CONTAINER_CREDENTIALS_PATH("aws.containerCredentialsPath", null),
    AWS_CBOR_ENABLED("aws.cborEnabled", "true"),
    AWS_BINARY_ION_ENABLED("aws.binaryIonEnabled", "true"),
    AWS_DEFAULT_METRICS("aws.defaultMetrics", null);

    private final String systemProperty;
    private final String defaultValue;

    private AwsSystemSetting(String systemProperty, String defaultValue) {
        this.systemProperty = systemProperty;
        this.defaultValue = defaultValue;
    }

    public String property() {
        return this.systemProperty;
    }

    public String environmentVariable() {
        return this.name();
    }

    public String defaultValue() {
        return this.defaultValue;
    }
}

