/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import java.io.File;
import software.amazon.awssdk.AwsSystemSetting;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.FileSystemCredentialsProvider;
import software.amazon.awssdk.auth.profile.ProfilesConfigFile;
import software.amazon.awssdk.profile.path.AwsProfileFileLocationProvider;
import software.amazon.awssdk.utils.Validate;

public class ProfileCredentialsProvider
extends FileSystemCredentialsProvider {
    private final ProfilesConfigFile profilesConfigFile;
    private final String profileName;

    public ProfileCredentialsProvider() {
        this(new Builder());
    }

    private ProfileCredentialsProvider(Builder builder) {
        if (builder.profilesConfigFile == null) {
            Validate.notNull((Object)builder.profileFileLocationProvider, (String)"Profile file location provider must not be null.", (Object[])new Object[0]);
            File defaultProfileFile = builder.profileFileLocationProvider.getLocation();
            this.profilesConfigFile = defaultProfileFile == null ? null : new ProfilesConfigFile(defaultProfileFile);
        } else {
            this.profilesConfigFile = builder.profilesConfigFile;
        }
        this.profileName = builder.profileName != null ? builder.profileName : AwsSystemSetting.AWS_DEFAULT_PROFILE.getStringValueOrThrow();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected AwsCredentials loadCredentials() {
        return this.profilesConfigFile == null ? null : this.profilesConfigFile.getCredentials(this.profileName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.profilesConfigFile + ", " + this.profileName + ")";
    }

    public static final class Builder {
        private ProfilesConfigFile profilesConfigFile;
        private String profileName;
        private AwsProfileFileLocationProvider profileFileLocationProvider = AwsProfileFileLocationProvider.DEFAULT_CREDENTIALS_LOCATION_PROVIDER;

        private Builder() {
        }

        public Builder profilesConfigFile(ProfilesConfigFile profilesConfigFile) {
            this.profilesConfigFile = profilesConfigFile;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        @SdkTestInternalApi
        Builder defaultProfilesConfigFileLocator(AwsProfileFileLocationProvider profileFileLocationProvider) {
            this.profileFileLocationProvider = profileFileLocationProvider;
            return this;
        }

        public ProfileCredentialsProvider build() {
            return new ProfileCredentialsProvider(this);
        }
    }
}

