/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.profile.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.AwsSessionCredentials;
import software.amazon.awssdk.auth.StaticCredentialsProvider;
import software.amazon.awssdk.auth.profile.internal.securitytoken.RoleInfo;

@Deprecated
@Immutable
public class Profile {
    private final String profileName;
    private final Map<String, String> properties;
    private final AwsCredentialsProvider awsCredentials;

    public Profile(String profileName, AwsCredentials awsCredentials) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("aws_access_key_id", awsCredentials.accessKeyId());
        properties.put("aws_secret_access_key", awsCredentials.secretAccessKey());
        if (awsCredentials instanceof AwsSessionCredentials) {
            AwsSessionCredentials sessionCred = (AwsSessionCredentials)awsCredentials;
            properties.put("aws_session_token", sessionCred.sessionToken());
        }
        this.profileName = profileName;
        this.properties = properties;
        this.awsCredentials = new StaticCredentialsProvider(awsCredentials);
    }

    public Profile(String profileName, String sourceProfile, AwsCredentialsProvider awsCredentials, RoleInfo roleInfo) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("source_profile", sourceProfile);
        properties.put("role_arn", roleInfo.getRoleArn());
        if (roleInfo.getRoleSessionName() != null) {
            properties.put("role_session_name", roleInfo.getRoleSessionName());
        }
        if (roleInfo.getExternalId() != null) {
            properties.put("external_id", roleInfo.getExternalId());
        }
        this.profileName = profileName;
        this.properties = properties;
        this.awsCredentials = awsCredentials;
    }

    public Profile(String profileName, Map<String, String> properties, AwsCredentialsProvider awsCredentials) {
        this.profileName = profileName;
        this.properties = properties;
        this.awsCredentials = awsCredentials;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public AwsCredentials getCredentials() {
        return this.awsCredentials.getCredentials();
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.properties);
    }

    public String getPropertyValue(String propertyName) {
        return this.getProperties().get(propertyName);
    }
}

