/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.profile.internal.securitytoken;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.profile.internal.securitytoken.ProfileCredentialsService;
import software.amazon.awssdk.auth.profile.internal.securitytoken.RoleInfo;

@ThreadSafe
public class StsProfileCredentialsServiceProvider
implements AwsCredentialsProvider {
    private static final String CLASS_NAME = "software.amazon.awssdk.services.securitytoken.internal.STSProfileCredentialsService";
    private static volatile ProfileCredentialsService STS_CREDENTIALS_SERVICE;
    private final RoleInfo roleInfo;
    private volatile AwsCredentialsProvider profileCredentialsProvider;

    public StsProfileCredentialsServiceProvider(RoleInfo roleInfo) {
        this.roleInfo = roleInfo;
    }

    private static synchronized ProfileCredentialsService getProfileCredentialService() {
        if (STS_CREDENTIALS_SERVICE == null) {
            try {
                STS_CREDENTIALS_SERVICE = (ProfileCredentialsService)Class.forName(CLASS_NAME).newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new SdkClientException("To use assume role profiles the aws-java-sdk-sts module must be on the class path.", ex);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new SdkClientException("Failed to instantiate software.amazon.awssdk.services.securitytoken.internal.STSProfileCredentialsService", ex);
            }
        }
        return STS_CREDENTIALS_SERVICE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AwsCredentialsProvider getProfileCredentialsProvider() {
        if (this.profileCredentialsProvider != null) return this.profileCredentialsProvider;
        Class<StsProfileCredentialsServiceProvider> clazz = StsProfileCredentialsServiceProvider.class;
        synchronized (StsProfileCredentialsServiceProvider.class) {
            if (this.profileCredentialsProvider != null) return this.profileCredentialsProvider;
            this.profileCredentialsProvider = StsProfileCredentialsServiceProvider.getProfileCredentialService().getAssumeRoleCredentialsProvider(this.roleInfo);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.profileCredentialsProvider;
        }
    }

    @Override
    public AwsCredentials getCredentials() {
        return this.getProfileCredentialsProvider().getCredentials();
    }
}

