/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.client;

import software.amazon.awssdk.Request;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.ServiceAdvancedConfiguration;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.async.AsyncRequestProvider;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;

@SdkProtectedApi
@NotThreadSafe
@ReviewBeforeRelease(value="Using old style withers/getters")
public class ClientExecutionParams<InputT, OutputT> {
    private InputT input;
    private AsyncRequestProvider asyncRequestProvider;
    private Marshaller<Request<InputT>, InputT> marshaller;
    private SdkHttpResponseHandler<OutputT> asyncResponseHandler;
    private HttpResponseHandler<OutputT> responseHandler;
    private HttpResponseHandler<? extends SdkBaseException> errorResponseHandler;
    private RequestConfig requestConfig;
    private ServiceAdvancedConfiguration serviceAdvancedConfiguration;

    public Marshaller<Request<InputT>, InputT> getMarshaller() {
        return this.marshaller;
    }

    public ClientExecutionParams<InputT, OutputT> withMarshaller(Marshaller<Request<InputT>, InputT> marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    public InputT getInput() {
        return this.input;
    }

    public ClientExecutionParams<InputT, OutputT> withInput(InputT input) {
        this.input = input;
        return this;
    }

    public SdkHttpResponseHandler<OutputT> getAsyncResponseHandler() {
        return this.asyncResponseHandler;
    }

    public ClientExecutionParams<InputT, OutputT> withAsyncResponseHandler(SdkHttpResponseHandler<OutputT> asyncResponseHandler) {
        this.asyncResponseHandler = asyncResponseHandler;
        return this;
    }

    public HttpResponseHandler<OutputT> getResponseHandler() {
        return this.responseHandler;
    }

    public ClientExecutionParams<InputT, OutputT> withResponseHandler(HttpResponseHandler<OutputT> responseHandler) {
        this.responseHandler = responseHandler;
        return this;
    }

    public HttpResponseHandler<? extends SdkBaseException> getErrorResponseHandler() {
        return this.errorResponseHandler;
    }

    public ClientExecutionParams<InputT, OutputT> withErrorResponseHandler(HttpResponseHandler<? extends SdkBaseException> errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public ClientExecutionParams<InputT, OutputT> withRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        return this;
    }

    public AsyncRequestProvider getAsyncRequestProvider() {
        return this.asyncRequestProvider;
    }

    public ClientExecutionParams<InputT, OutputT> withAsyncRequestProvider(AsyncRequestProvider asyncRequestProvider) {
        this.asyncRequestProvider = asyncRequestProvider;
        return this;
    }

    public ServiceAdvancedConfiguration getServiceAdvancedConfiguration() {
        return this.serviceAdvancedConfiguration;
    }

    public ClientExecutionParams<InputT, OutputT> withServiceAdvancedConfiguration(ServiceAdvancedConfiguration serviceConfig) {
        this.serviceAdvancedConfiguration = serviceConfig;
        return this;
    }
}

