/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.http.timers.client;

import java.util.concurrent.ScheduledFuture;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.Abortable;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionAbortTask;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionAbortTrackerTask;
import software.amazon.awssdk.util.ValidationUtils;

@SdkInternalApi
public class ClientExecutionAbortTrackerTaskImpl
implements ClientExecutionAbortTrackerTask {
    private final ClientExecutionAbortTask task;
    private final ScheduledFuture<?> future;

    public ClientExecutionAbortTrackerTaskImpl(ClientExecutionAbortTask task, ScheduledFuture<?> future) {
        this.task = ValidationUtils.assertNotNull(task, "task");
        this.future = ValidationUtils.assertNotNull(future, "future");
    }

    @Override
    public void setCurrentHttpRequest(Abortable newRequest) {
        this.task.setCurrentHttpRequest(newRequest);
    }

    @Override
    public boolean hasTimeoutExpired() {
        return this.task.hasClientExecutionAborted();
    }

    @Override
    public boolean isEnabled() {
        return this.task.isEnabled();
    }

    @Override
    public void cancelTask() {
        this.future.cancel(false);
    }
}

