/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.json.internal;

import java.time.Instant;
import java.util.Date;
import java.util.function.Function;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.util.StringUtils;

@SdkInternalApi
public class ValueToStringConverters {
    public static final ValueToString<String> FROM_STRING = val -> val;
    public static final ValueToString<Integer> FROM_INTEGER = StringUtils::fromInteger;
    public static final ValueToString<Long> FROM_LONG = StringUtils::fromLong;
    public static final ValueToString<Float> FROM_FLOAT = StringUtils::fromFloat;
    public static final ValueToString<Double> FROM_DOUBLE = StringUtils::fromDouble;
    public static final ValueToString<Boolean> FROM_BOOLEAN = StringUtils::fromBoolean;
    public static final ValueToString<Instant> FROM_INSTANT = i -> StringUtils.fromDate(Date.from(i));

    @FunctionalInterface
    public static interface ValueToString<T>
    extends Function<T, String> {
    }
}

