/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.transform;

import java.nio.ByteBuffer;
import java.util.Date;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.util.XpathUtils;

@SdkProtectedApi
public class SimpleTypeUnmarshallers {

    public static class ByteBufferUnmarshaller
    implements Unmarshaller<ByteBuffer, Node> {
        private static volatile ByteBufferUnmarshaller instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ByteBufferUnmarshaller getInstance() {
            if (instance != null) return instance;
            Class<ByteBufferUnmarshaller> clazz = ByteBufferUnmarshaller.class;
            synchronized (ByteBufferUnmarshaller.class) {
                if (instance != null) return instance;
                instance = new ByteBufferUnmarshaller();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public ByteBuffer unmarshall(Node in) throws Exception {
            return XpathUtils.asByteBuffer(".", in);
        }
    }

    public static class DateUnmarshaller
    implements Unmarshaller<Date, Node> {
        private static volatile DateUnmarshaller instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static DateUnmarshaller getInstance() {
            if (instance != null) return instance;
            Class<DateUnmarshaller> clazz = DateUnmarshaller.class;
            synchronized (DateUnmarshaller.class) {
                if (instance != null) return instance;
                instance = new DateUnmarshaller();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public Date unmarshall(Node in) throws Exception {
            return XpathUtils.asDate(".", in);
        }
    }

    public static class ByteUnmarshaller
    implements Unmarshaller<Byte, Node> {
        private static volatile ByteUnmarshaller instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ByteUnmarshaller getInstance() {
            if (instance != null) return instance;
            Class<ByteUnmarshaller> clazz = ByteUnmarshaller.class;
            synchronized (ByteUnmarshaller.class) {
                if (instance != null) return instance;
                instance = new ByteUnmarshaller();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public Byte unmarshall(Node in) throws Exception {
            return XpathUtils.asByte(".", in);
        }
    }

    public static class LongUnmarshaller
    implements Unmarshaller<Long, Node> {
        private static volatile LongUnmarshaller instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static LongUnmarshaller getInstance() {
            if (instance != null) return instance;
            Class<LongUnmarshaller> clazz = LongUnmarshaller.class;
            synchronized (LongUnmarshaller.class) {
                if (instance != null) return instance;
                instance = new LongUnmarshaller();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public Long unmarshall(Node in) throws Exception {
            return XpathUtils.asLong(".", in);
        }
    }

    public static class FloatUnmarshaller
    implements Unmarshaller<Float, Node> {
        private static volatile FloatUnmarshaller instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static FloatUnmarshaller getInstance() {
            if (instance != null) return instance;
            Class<FloatUnmarshaller> clazz = FloatUnmarshaller.class;
            synchronized (FloatUnmarshaller.class) {
                if (instance != null) return instance;
                instance = new FloatUnmarshaller();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public Float unmarshall(Node in) throws Exception {
            return XpathUtils.asFloat(".", in);
        }
    }

    public static class BooleanUnmarshaller
    implements Unmarshaller<Boolean, Node> {
        private static volatile BooleanUnmarshaller instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static BooleanUnmarshaller getInstance() {
            if (instance != null) return instance;
            Class<BooleanUnmarshaller> clazz = BooleanUnmarshaller.class;
            synchronized (BooleanUnmarshaller.class) {
                if (instance != null) return instance;
                instance = new BooleanUnmarshaller();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public Boolean unmarshall(Node in) throws Exception {
            return XpathUtils.asBoolean(".", in);
        }
    }

    public static class IntegerUnmarshaller
    implements Unmarshaller<Integer, Node> {
        private static volatile IntegerUnmarshaller instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static IntegerUnmarshaller getInstance() {
            if (instance != null) return instance;
            Class<IntegerUnmarshaller> clazz = IntegerUnmarshaller.class;
            synchronized (IntegerUnmarshaller.class) {
                if (instance != null) return instance;
                instance = new IntegerUnmarshaller();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public Integer unmarshall(Node in) throws Exception {
            return XpathUtils.asInteger(".", in);
        }
    }

    public static class DoubleUnmarshaller
    implements Unmarshaller<Double, Node> {
        private static volatile DoubleUnmarshaller instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static DoubleUnmarshaller getInstance() {
            if (instance != null) return instance;
            Class<DoubleUnmarshaller> clazz = DoubleUnmarshaller.class;
            synchronized (DoubleUnmarshaller.class) {
                if (instance != null) return instance;
                instance = new DoubleUnmarshaller();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public Double unmarshall(Node in) throws Exception {
            return XpathUtils.asDouble(".", in);
        }
    }

    public static class StringUnmarshaller
    implements Unmarshaller<String, Node> {
        private static volatile StringUnmarshaller instance;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static StringUnmarshaller getInstance() {
            if (instance != null) return instance;
            Class<StringUnmarshaller> clazz = StringUnmarshaller.class;
            synchronized (StringUnmarshaller.class) {
                if (instance != null) return instance;
                instance = new StringUnmarshaller();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Override
        public String unmarshall(Node in) throws Exception {
            return XpathUtils.asString(".", in);
        }
    }
}

