/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.util;

import java.util.stream.Stream;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;

@ReviewBeforeRelease(value="We should consider migrating this and other related util classes to the utils package.")
public final class ComparableUtils {
    private ComparableUtils() {
    }

    public static <T> int safeCompare(Comparable<T> d1, T d2) {
        if (d1 != null && d2 != null) {
            return d1.compareTo(d2);
        }
        if (d1 == null && d2 != null) {
            return -1;
        }
        if (d1 != null) {
            return 1;
        }
        return 0;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> T minimum(T ... values) {
        return (T)(values == null ? null : (Comparable)Stream.of(values).min(Comparable::compareTo).orElse(null));
    }
}

