/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.util.BasicNameValuePair;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UrlEncodedUtils;

public class SdkHttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN = Pattern.compile(Pattern.quote("+") + "|" + Pattern.quote("*") + "|" + Pattern.quote("%7E") + "|" + Pattern.quote("%2F"));

    public static String urlEncode(String value, boolean path) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, DEFAULT_ENCODING);
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
            StringBuffer buffer = new StringBuffer(encoded.length());
            while (matcher.find()) {
                String replacement = matcher.group(0);
                if ("+".equals(replacement)) {
                    replacement = "%20";
                } else if ("*".equals(replacement)) {
                    replacement = "%2A";
                } else if ("%7E".equals(replacement)) {
                    replacement = "~";
                } else if (path && "%2F".equals(replacement)) {
                    replacement = "/";
                }
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String urlDecode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isUsingNonDefaultPort(URI uri) {
        String scheme = StringUtils.lowerCase(uri.getScheme());
        int port = uri.getPort();
        if (port <= 0) {
            return false;
        }
        if (scheme.equals("http") && port == 80) {
            return false;
        }
        return !scheme.equals("https") || port != 443;
    }

    public static String encodeParameters(SdkHttpRequest request) {
        Map requestParams = request.getParameters();
        if (requestParams.isEmpty()) {
            return "";
        }
        ArrayList nameValuePairs = new ArrayList();
        for (Map.Entry entry : requestParams.entrySet()) {
            String parameterName = (String)entry.getKey();
            nameValuePairs.addAll(((List)entry.getValue()).stream().map(value -> new BasicNameValuePair(parameterName, (String)value)).collect(Collectors.toList()));
        }
        return UrlEncodedUtils.format(nameValuePairs, DEFAULT_ENCODING);
    }

    public static String appendUri(String baseUri, String path) {
        return SdkHttpUtils.appendUri(baseUri, path, false);
    }

    public static String appendUri(String baseUri, String path, boolean escapeDoubleSlash) {
        String resultUri = baseUri;
        if (path != null && path.length() > 0) {
            if (path.startsWith("/")) {
                if (resultUri.endsWith("/")) {
                    resultUri = resultUri.substring(0, resultUri.length() - 1);
                }
            } else if (!resultUri.endsWith("/")) {
                resultUri = resultUri + "/";
            }
            resultUri = escapeDoubleSlash ? resultUri + path.replace("//", "/%2F") : resultUri + path;
        } else if (!resultUri.endsWith("/")) {
            resultUri = resultUri + "/";
        }
        return resultUri;
    }
}

