/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import java.io.IOException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.retry.internal.CredentialsEndpointRetryParameters;
import software.amazon.awssdk.retry.internal.CredentialsEndpointRetryPolicy;

@SdkInternalApi
class ContainerCredentialsRetryPolicy
implements CredentialsEndpointRetryPolicy {
    private static final int MAX_RETRIES = 5;

    ContainerCredentialsRetryPolicy() {
    }

    @Override
    public boolean shouldRetry(int retriesAttempted, CredentialsEndpointRetryParameters retryParams) {
        if (retriesAttempted >= 5) {
            return false;
        }
        Integer statusCode = retryParams.getStatusCode();
        if (statusCode != null && statusCode >= 500 && statusCode < 600) {
            return true;
        }
        return retryParams.getException() != null && retryParams.getException() instanceof IOException;
    }
}

