/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.metrics.spi.MetricType;
import software.amazon.awssdk.utils.Validate;

public class MetricsReportingCredentialsProvider
implements AwsCredentialsProvider {
    private final AwsCredentialsProvider delegate;
    private final AwsRequestMetrics awsRequestMetrics;

    public MetricsReportingCredentialsProvider(AwsCredentialsProvider delegate, AwsRequestMetrics awsRequestMetrics) {
        this.delegate = (AwsCredentialsProvider)Validate.notNull((Object)delegate, (String)"Delegate must not be null.", (Object[])new Object[0]);
        this.awsRequestMetrics = (AwsRequestMetrics)Validate.notNull((Object)awsRequestMetrics, (String)"Metrics must not be null.", (Object[])new Object[0]);
    }

    @Override
    public AwsCredentials getCredentials() {
        this.awsRequestMetrics.startEvent((MetricType)AwsRequestMetrics.Field.CredentialsRequestTime);
        try {
            AwsCredentials awsCredentials = this.delegate.getCredentials();
            return awsCredentials;
        }
        finally {
            this.awsRequestMetrics.endEvent((MetricType)AwsRequestMetrics.Field.CredentialsRequestTime);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.delegate + ")";
    }
}

