/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.presign;

import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.Presigner;
import software.amazon.awssdk.auth.presign.PresignerParams;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.runtime.auth.SignerProviderContext;
import software.amazon.awssdk.util.CredentialUtils;
import software.amazon.awssdk.util.RuntimeHttpUtils;

@Immutable
@SdkProtectedApi
public final class PresignerFacade {
    private final AwsCredentialsProvider credentialsProvider;
    private final SignerProvider signerProvider;

    public PresignerFacade(PresignerParams presignerParams) {
        this.credentialsProvider = presignerParams.credentialsProvider();
        this.signerProvider = presignerParams.signerProvider();
    }

    public URL presign(SdkHttpFullRequest request, RequestConfig requestConfig, Date expirationDate) {
        Presigner presigner = (Presigner)((Object)this.signerProvider.getSigner(SignerProviderContext.builder().withIsRedirect(false).withRequest(request).withUri(request.getEndpoint()).build()));
        SdkHttpFullRequest.Builder mutableRequest = (SdkHttpFullRequest.Builder)request.toBuilder();
        if (requestConfig != null) {
            this.addCustomQueryParams(mutableRequest, requestConfig);
            this.addCustomHeaders(mutableRequest, requestConfig);
        }
        AwsCredentialsProvider credentialsProvider = this.resolveCredentials(requestConfig);
        SdkHttpFullRequest signed = presigner.presignRequest((SdkHttpFullRequest)mutableRequest.build(), credentialsProvider.getCredentials(), expirationDate);
        return RuntimeHttpUtils.convertRequestToUrl(signed, true, false);
    }

    private void addCustomQueryParams(SdkHttpFullRequest.Builder request, RequestConfig requestConfig) {
        Map<String, List<String>> queryParameters = requestConfig.getCustomQueryParameters();
        if (queryParameters == null || queryParameters.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<String>> param : queryParameters.entrySet()) {
            request.queryParameter(param.getKey(), param.getValue());
        }
    }

    private void addCustomHeaders(SdkHttpFullRequest.Builder request, RequestConfig requestConfig) {
        Map<String, String> headers = requestConfig.getCustomRequestHeaders();
        if (headers == null || headers.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.header(header.getKey(), header.getValue());
        }
    }

    private AwsCredentialsProvider resolveCredentials(RequestConfig requestConfig) {
        return CredentialUtils.getCredentialsProvider(requestConfig, this.credentialsProvider);
    }
}

